<?php
/**
 * Template part for displaying single post and page
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="post_title">
		<h2>
			<?php
				the_title();
			?>
		</h2>
	</div><!-- .post_title -->
	<?php
		do_action( 'one_hive_breadcrumb' );
	?>
	<div class="single_page_actual_content_holder">
		<?php
			if( has_post_thumbnail() ) :
				?>
				<div class="post_fimage">
					<?php
						one_hive_post_thumbnail();
					?>
				</div><!-- .post_fimage -->
				<?php
			endif;

			if( get_post_type() == 'post' ) :
				?>
				<div class="single_meta">
					<ul class="meta_list">
						<li class="author_name">
							<?php
								one_hive_get_post_author();
							?>
						</li><!-- .author_name -->
						<li class="posted_category">
							<?php
								one_hive_get_categories();
							?>
						</li><!-- .posted_category -->
						<li class="posted_date">
							<?php
								one_hive_get_post_date();
							?>
						</li><!-- .posted_date -->
					</ul><!-- .meta_list -->
				</div><!-- .single_meta -->
				<?php
			endif;
		?>
		<div class="the_content">
			<?php
				the_content();

				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'one-hive' ),
					'after'  => '</div>',
				) );

				if( get_edit_post_link() && ( get_post_type() == 'page' ) ) :
					edit_post_link(
						sprintf(
							wp_kses(
								/* translators: %s: Name of current post. Only visible to screen readers */
								__( 'Edit <span class="screen-reader-text">%s</span>', 'one-hive' ),
								array(
									'span' => array(
										'class' => array(),
									),
								)
							),
							get_the_title()
						),
						'<span class="edit-link">',
						'</span>'
					);
				endif;
			?>
		</div><!-- .the_content -->
	</div><!-- .single_page_actual_content_holder -->
</article><!-- #post-<?php the_ID(); ?> -->