<?php
/**
 * Template part for displaying testimonial section
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */
	
	$enable_testimonial_section = one_hive_get_option( 'one_hive_enable_testimonial_section' );

	$testimonial_section_id = one_hive_get_option( 'one_hive_testimonial_section_id' );

	$section_title = one_hive_get_option( 'one_hive_testimonial_section_title' );

	$section_desc = one_hive_get_option( 'one_hive_testimonial_section_description' );

	$testimonial_contents = one_hive_get_option( 'one_hive_testimonial_contents' );


	if( $enable_testimonial_section == 1 && !empty( $testimonial_contents ) ) :
		?>
		<section id="<?php echo esc_attr( $testimonial_section_id ); ?>" class="oh_testinomial section_bg">
	        <div class="section_inner">
	            <div class="oh_container">
	                <?php
	            		if( !empty( $section_title ) ) :
			            	?>
			                <div class="section_title">
			                    <h2>
			                    	<?php
			                    		echo esc_html( $section_title );
			                    	?>
			                    </h2>
			                </div><!-- .section_title -->
			                <?php
	                	endif;

	                	if( !empty( $section_desc ) ) :
			                ?>
			                <div class="section_desc">
			                    <p>
			                    	<?php
			                    		echo esc_html( $section_desc );
			                    	?>
			                    </p>
			                </div><!-- .section_desc -->
			                <?php
	                	endif;
	                ?>
	                <div class="section_content">
	                    <div class="row">
	                        <div class="owl-carousel owl-theme testinomial_carousel">
	                        	<?php
	                        		foreach( $testimonial_contents as $content ) :

	                        			$client_args = array();
	                			
			                			if( absint( $content['one_hive_client_page'] ) > 0  ) {
			                				$client_args['post_type'] = 'page';
			                				$client_args['page_id'] = absint( $content['one_hive_client_page'] );
			                			}

	                        			$client_page = new WP_Query( $client_args );

	                        			if( $client_page->have_posts() ) :
	                        				while( $client_page->have_posts() ) :
	                        					$client_page->the_post();
					                        	?>
					                            <div class="item testinomial_item">
					                                <div class="testinomial_content_outer">
					                                    <div class="testi_content_inner">
					                                        <div class="testi_desc">
					                                            <?php
					                                            	the_content();
					                                            ?>
					                                        </div><!-- .testi_desc -->
					                                    </div><!-- .testi_content_inner -->
					                                    <div class="author_meta_holder clearfix">
					                                        <div class="testi_author_desc">
					                                        	<?php
					                                        		if( has_post_thumbnail() ) :
							                                        	?>
							                                            <div class="author_fimage">
							                                            	<?php
							                                                	the_post_thumbnail( 'one-hive-thumbnail-1', array( 'class' => 'img-responsive', 'alt' => the_title_attribute( array( 'echo' => false ) ) ) );
							                                                ?>
							                                            </div><!-- .author_fimage -->
							                                            <?php
					                                            	endif;
					                                            ?>
					                                            <div class="author_misc">
					                                                <span class="author_name">
					                                                	<?php
					                                                		the_title();
					                                                	?>
					                                                </span><!-- .author_name -->
					                                            </div><!-- .author_misc -->
					                                        </div><!-- .testi_author_desc -->
					                                    </div><!-- .author_meta_holder.clearfix -->
					                                    <div class="clearfix"></div><!-- .clearfix -->
					                                </div><!-- .testinomial_content_outer -->
					                            </div><!-- .item.testinomial_item -->
					                            <?php
	                            			endwhile;
	                            			wp_reset_postdata();
	                            		endif;
	                            	endforeach;
	                            ?>
	                        </div><!-- .owl-carousel.owl-theme.testinomial_carousel -->
	                    </div><!-- .row -->
	                </div><!-- .section_content -->
	            </div><!-- .oh_container -->
	        </div><!-- .section_inner -->
	    </section><!-- .section_bg -->
		<?php
	endif;
?>