<?php
/**
 * Template part for displaying team section
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */
	
	$enable_team_section = one_hive_get_option( 'one_hive_enable_team_section' );

	$team_section_id = one_hive_get_option( 'one_hive_team_section_id' );

	$section_title = one_hive_get_option( 'one_hive_team_section_title' );

	$section_desc = one_hive_get_option( 'one_hive_team_section_description' );

	$team_contents = one_hive_get_option( 'one_hive_team_contents' );

	if( $enable_team_section == 1 && !empty( $team_contents ) ) :
		?>
		<section id="<?php echo esc_attr( $team_section_id ); ?>" class="team section_bg">
	        <div class="section_inner">
	            <div class="oh_container">
	                <?php
	            		if( !empty( $section_title ) ) :
			            	?>
			                <div class="section_title">
			                    <h2>
			                    	<?php
			                    		echo esc_html( $section_title );
			                    	?>
			                    </h2>
			                </div><!-- .section_title -->
			                <?php
	                	endif;

	                	if( !empty( $section_desc ) ) :
			                ?>
			                <div class="section_desc">
			                    <p>
			                    	<?php
			                    		echo esc_html( $section_desc );
			                    	?>
			                    </p>
			                </div><!-- .section_desc -->
			                <?php
	                	endif;
	                ?>
	                <div class="section_content">
	                    <div class="owl-carousel owl-theme team_carousel">
	                    	<?php
	                    		foreach( $team_contents as $content ) :

	                    			$team_args = array();
	                			
		                			if( absint( $content['one_hive_team_page'] ) > 0  ) {
		                				$team_args['post_type'] = 'page';
		                				$team_args['page_id'] = absint( $content['one_hive_team_page'] );
		                			}

	                    			$team_query = new WP_Query( $team_args );

	                    			if( $team_query->have_posts() ) :
	                    				while( $team_query->have_posts() ) :
	                    					$team_query->the_post();
					                    	?>
					                        <div class="item">
					                            <div class="item_container">
					                            	<?php
					                            		if( has_post_thumbnail() ) :
							                            	?>
							                                <div class="team_fimage">
							                                	<?php
							                                		the_post_thumbnail( 'one-hive-thumbnail-2', array( 'class' => 'img-responsive', 'alt' => the_title_attribute( array( 'echo' => false ) ) ) );
							                                	?>
							                                </div><!-- .team_fimage -->
							                                <?php
					                                	endif;
					                                ?>
					                                <div class="team_details content_holder">
					                                    <div class="service_title">
					                                        <h3>
					                                        	<?php
					                                        		the_title();
					                                        	?>
					                                        </h3>
					                                    </div><!-- .service_title -->
					                                    <div class="service_desc">
					                                        <?php
					                                        	the_content();
					                                        ?>
					                                    </div><!-- .service_desc -->
					                                </div><!-- .team_details.content_holder -->
					                            </div><!-- .iteam_container -->
					                        </div><!-- .item -->
					                        <?php
	                        			endwhile;
	                        			wp_reset_postdata();
	                        		endif;
	                        	endforeach;
	                        ?>
	                    </div><!-- .owl-carousel.owl-theme.team_carousel -->
	                </div><!-- .section_content -->
	            </div><!-- .oh_container -->
	        </div><!-- .section_inner -->
	    </section><!-- .section_bg -->
		<?php
	endif;
?>