<?php
/**
 * Template part for displaying partner section
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive_Pro
 */
	
	$enable_partner_section = one_hive_get_option( 'one_hive_enable_partner_section' );

	$partner_section_id = one_hive_get_option( 'one_hive_partner_section_id' );

	$section_title = one_hive_get_option( 'one_hive_partner_section_title' );

	$section_desc = one_hive_get_option( 'one_hive_partner_section_description' );

	$partner_contents = one_hive_get_option( 'one_hive_partner_contents' );

	if( $enable_partner_section == 1 && !empty( $partner_contents ) ) :
		?>
		<section id="<?php echo esc_attr( $partner_section_id ); ?>" class="oh_client">
	        <div class="section_inner">
	            <div class="oh_container">
	                <?php
	            		if( !empty( $section_title ) ) :
			            	?>
			                <div class="section_title">
			                    <h2>
			                    	<?php
			                    		echo esc_html( $section_title );
			                    	?>
			                    </h2>
			                </div><!-- .section_title -->
			                <?php
	                	endif;

	                	if( !empty( $section_desc ) ) :
			                ?>
			                <div class="section_desc">
			                    <p>
			                    	<?php
			                    		echo esc_html( $section_desc );
			                    	?>
			                    </p>
			                </div><!-- .section_desc -->
			                <?php
	                	endif;
	                ?>
	                <div class="owl-carousel owl-theme client_carousel">
	                	<?php
	                		foreach( $partner_contents as $content ) :

	                			$partner_args = array();
	                			
	                			if( absint( $content['one_hive_partner_page'] ) > 0  ) {
	                				$partner_args['post_type'] = 'page';
	                				$partner_args['page_id'] = absint( $content['one_hive_partner_page'] );
	                			}

                    			$partner_page = new WP_Query( $partner_args );

	                			if( $partner_page->have_posts() ) :
	                				while( $partner_page->have_posts() ) : 
	                					$partner_page->the_post();
	                					if( has_post_thumbnail() ) :
						                	?>
						                    <div class="item">
						                        <?php the_post_thumbnail( 'full', array( 'alt' => the_title_attribute( array( 'echo' => false ) ) ) ); ?>
						                    </div><!-- .item -->
						                    <?php
						                endif;
				                    endwhile;
				                    wp_reset_postdata();
			                	endif;
	                    	endforeach;
	                    ?>
	                </div><!-- .owl-carousel.owl-theme.client_carousel -->
	            </div><!-- .oh_container -->
	        </div><!-- .section_inner -->
	    </section><!-- .oh_client -->
		<?php
	endif;
?>