<?php
/**
 * Template part for displaying news section
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */

	$enable_news_section = one_hive_get_option( 'one_hive_enable_news_section' );

	$section_id = one_hive_get_option( 'one_hive_news_section_id' );

    $section_title = one_hive_get_option( 'one_hive_news_section_title' );

    $section_desc = one_hive_get_option( 'one_hive_news_section_description' );

    $news_cat = one_hive_get_option( 'one_hive_news_post_category' );

    $news_post_no = one_hive_get_option( 'one_hive_news_posts_number' );

    $news_args = array(
        'post_type' => 'post',
    );

    if( !empty( $news_cat ) ) {
        $news_args['cat'] = $news_cat;
    }

    if( !empty( $news_post_no ) ) {
        $news_args['posts_per_page'] = absint( $news_post_no );
    }

    $news_query = new WP_Query( $news_args );

    if( $enable_news_section == 1 && $news_query->have_posts() ) :
        ?>
        <section id="<?php echo esc_attr( $section_id ); ?>" class="blog_layout_one">
            <div class="section_inner">
                <div class="oh_container">
                    <?php
                        if( !empty( $section_title ) ) :
                            ?>
                            <div class="section_title">
                                <h2>
                                    <?php
                                        echo esc_html( $section_title );
                                    ?>
                                </h2>
                            </div><!-- .section_title -->
                            <?php
                        endif;

                        if( !empty( $section_desc ) ) :
                            ?>
                            <div class="section_desc">
                                <p>
                                    <?php
                                        echo esc_html( $section_desc );
                                    ?>
                                </p>
                            </div><!-- .section_desc -->
                            <?php
                        endif;
                    ?>
                    <div class="owl-carousel blog_layout_one_carousel">
                        <?php
                            while( $news_query->have_posts() ) :
                                $news_query->the_post();
                                ?>
                                <div class="item">
                                    <div class="card_content_holder">
                                        <div class="card">
                                            <?php
                                                if( has_post_thumbnail() ) :
                                                    ?>
                                                    <div class="card_fimage" style="background-image: url(<?php esc_url( the_post_thumbnail_url( 'full' ) ); ?>);">
                                                    <?php
                                                else :
                                                    ?>
                                                    <div class="card_fimage">
                                                    <?php
                                                endif;
                                            ?>
                                                <div class="card_details">
                                                    <div class="card_title">
                                                        <h3>
                                                            <a href="<?php the_permalink(); ?>">
                                                                <?php
                                                                    the_title();
                                                                ?>
                                                            </a>
                                                        </h3>
                                                    </div><!-- .card_title -->
                                                    <div class="card_permalink">
                                                        <a href="<?php the_permalink(); ?>">
                                                            <?php 
                                                                esc_html_e( '→', 'one-hive' ); 
                                                            ?>
                                                        </a>
                                                    </div><!-- .card_permalink -->
                                                </div><!-- .card_details -->
                                                <div class="mask"></div><!-- .mask -->
                                            </div><!-- .card_fimage -->
                                        </div><!-- .card -->
                                    </div><!-- .card_content_holder -->
                                </div><!-- .item -->
                                <?php
                            endwhile;
                            wp_reset_postdata();
                        ?>
                    </div><!-- .owl-carousel.news_layout_one_carousel -->
                </div><!-- .oh_container -->
            </div><!-- .section_inner -->
        </section><!---->
        <?php
    endif;
?>