<?php
/**
 * Template part for displaying feature section
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */

	$enable_feature = one_hive_get_option( 'one_hive_enable_feature_section' );

	$section_id = one_hive_get_option( 'one_hive_feature_section_id' );

	$section_title = one_hive_get_option( 'one_hive_feature_section_title' );

	$section_desc = one_hive_get_option( 'one_hive_feature_section_description' );

	$feature_contents = one_hive_get_option( 'one_hive_feature_contents' );


	if( $enable_feature == 1 && !empty( $feature_contents ) ) {
		?>
		<section id="<?php echo esc_attr( $section_id ); ?>" class="features_one">
	        <div class="section_inner">
	            <div class="oh_container">
	            	<?php
	            		if( !empty( $section_title ) ) :
			            	?>
			                <div class="section_title">
			                    <h2>
			                    	<?php
			                    		echo esc_html( $section_title );
			                    	?>
			                    </h2>
			                </div><!-- .section_title -->
			                <?php
	                	endif;

	                	if( !empty( $section_desc ) ) :
			                ?>
			                <div class="section_desc">
			                    <p>
			                    	<?php
			                    		echo esc_html( $section_desc );
			                    	?>
			                    </p>
			                </div><!-- .section_desc -->
			                <?php
	                	endif;
	                ?>
	                <div class="row">
	                	<?php
	                		foreach( $feature_contents as $content ) :

	                			$feature_args = array();
	                			
	                			if( absint( $content['one_hive_feature_page'] ) > 0  ) {
	                				$feature_args['post_type'] = 'page';
	                				$feature_args['page_id'] = absint( $content['one_hive_feature_page'] );
	                			}
	                			
	                			$feature_query = new WP_Query( $feature_args );

	                			$feature_icon = $content['one_hive_feature_icon'];

	                			if( $feature_query->have_posts() ) :
	                				while( $feature_query->have_posts() ) :
	                					$feature_query->the_post();
					                	?>
					                    <div class="col-md-4 col-sm-6 col-xs-12">
					                        <div class="card_content_holder watchheight">
					                            <div class="card">
					                            	<?php
					                            		if( !empty( $feature_icon ) ) :
							                            	?>
							                                <div class="card_icon">
							                                    <span>
							                                    	<i class="fa <?php echo esc_attr( $feature_icon ); ?>"></i>
							                                    </span>
							                                </div><!-- .card_icon -->
							                                <?php
					                                	endif;
					                                ?>
					                                <div class="title">
					                                    <h3>
					                                    	<?php
					                                    		the_title();
					                                    	?>
					                                    </h3>
					                                </div><!-- .title -->
					                                <div class="desc">
					                                    <?php
					                                    	the_content();
					                                    ?>
					                                </div><!-- .desc -->
					                            </div><!-- .card -->
					                        </div><!-- .card_content_holder.watchheight -->
					                    </div><!-- .col-* -->
					                    <?php
			                    	endwhile;
			                    	wp_reset_postdata();
			                    endif;
	                		endforeach;
	                    ?>
	                </div><!-- .row -->
	            </div><!-- .oh_container -->
	        </div><!-- .section_inner -->
	    </section><!-- .section_bg -->
		<?php
	}