<?php
/**
 * Template part for displaying CTA section
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */
	
	$enable_cta_section = one_hive_get_option( 'one_hive_enable_cta_section' );

	$cta_section_id = one_hive_get_option( 'one_hive_cta_section_id' );

	$cta_page = one_hive_get_option( 'one_hive_cta_page' );

	$cta_args = array();

	if( absint( $cta_page ) > 0 ) {
		$cta_args['post_type'] = 'page';
		$cta_args['page_id'] = absint( $cta_page );
	}

	$cta_query = new WP_Query( $cta_args );

	if( $enable_cta_section == 1 && $cta_query->have_posts() ) :
		while( $cta_query->have_posts() ) :
			$cta_query->the_post();
			?>
			<section id="<?php echo esc_attr( $cta_section_id ); ?>" class="oh_cta">
				<?php
					if( has_post_thumbnail() ) :
						?>
				        <div class="section_inner" style="background-image: url(<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ); ?>)">
				        <?php
		        	else :
				        ?>
				        <div class="section_inner">
				        <?php
		        	endif;
		        ?>
		            <div class="oh_container">
		                <div class="cta_contents_holder">
		                    <div class="cta_desc">
		                    	<div class="section_title">
	                                <h2><?php the_title(); ?></h2>
	                            </div><!-- .section_title -->
		                        <span>
		                        	<?php
		                        		the_content();
		                        	?>
		                        </span>
		                    </div><!-- .cta_desc -->
		                </div><!-- .cta_contents_holder -->
		            </div><!-- .oh_container -->
		        </div><!-- .section_inner -->
		        <div class="mask"></div><!-- .mask -->
		    </section><!---->
			<?php
		endwhile;
		wp_reset_postdata();
	endif;
?>