<?php
/**
 * Template part for displaying contact section
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */
    
    $enable_contact_section = one_hive_get_option( 'one_hive_enable_contact_section' );

    $contact_section_id = one_hive_get_option( 'one_hive_contact_section_id' );

    $section_title = one_hive_get_option( 'one_hive_contact_section_title' );

    $section_desc = one_hive_get_option( 'one_hive_contact_section_description' );

    $contact_form_shortcode = one_hive_get_option( 'one_hive_contact_form_shortcode' );

    if( $enable_contact_section == 1 ) :
        ?>
        <section id="<?php echo esc_attr( $contact_section_id ); ?>" class="oh_contact">
            <div class="section_inner">
                <div class="oh_container">
                    <?php
                        if( !empty( $section_title ) ) :
                            ?>
                            <div class="section_title">
                                <h2>
                                    <?php
                                        echo esc_html( $section_title );
                                    ?>
                                </h2>
                            </div><!-- .section_title -->
                            <?php
                        endif;

                        if( !empty( $section_desc ) ) :
                            ?>
                            <div class="section_desc">
                                <p>
                                    <?php
                                        echo esc_html( $section_desc );
                                    ?>
                                </p>
                            </div><!-- .section_desc -->
                            <?php
                        endif;
                    ?>
                    <div class="section_content">
                        <div class="row">
                            <?php 
                                if( is_active_sidebar( 'sidebar-3' ) ) : 
                                    ?>
                                    <div class="col-md-7 col-sm-7 col-xs-12">
                                        <div class="map">
                                            <?php dynamic_sidebar( 'sidebar-3' ); ?>
                                        </div><!-- .map -->
                                    </div><!-- .col-* -->
                                    <?php 
                                endif; 

                                if( !empty( $contact_form_shortcode ) ) :
                                    ?>
                                     <div class="col-md-5 col-sm-5 col-xs-12">
                                        <div class="contact_form">
                                            <?php echo do_shortcode( $contact_form_shortcode ); ?>
                                        </div><!-- .contact_form -->
                                    </div><!-- .col-* -->
                                    <?php
                                endif;
                            ?>
                        </div><!-- .row -->
                    </div><!-- .section_content -->
                </div><!-- .oh_container -->
            </div><!-- .section_inner -->
        </section><!-- .oh_contact -->
        <?php
    endif;