<?php
/**
 * Template part for displaying blog section
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */

	$enable_blog_section = one_hive_get_option( 'one_hive_enable_blog_section' );

	$section_id = one_hive_get_option( 'one_hive_blog_section_id' );

    $section_title = one_hive_get_option( 'one_hive_blog_section_title' );

    $section_desc = one_hive_get_option( 'one_hive_blog_section_description' );

    $blog_post_cat = one_hive_get_option( 'one_hive_blog_post_category' );

    $blog_post_no = one_hive_get_option( 'one_hive_blog_posts_number' );

    $blog_args = array(
        'post_type' => 'post',
    );

    if( !empty( $blog_post_cat ) ) {
        $blog_args['cat'] = $blog_post_cat;
    }

    if( !empty( $blog_post_no ) ) {
        $blog_args['posts_per_page'] = absint( $blog_post_no );
    }

    $blog_query = new WP_Query( $blog_args );

    if( $enable_blog_section == 1 && $blog_query->have_posts() ) :
        ?>
        <section id="<?php echo esc_attr( $section_id ); ?>" class="oh_blog_layout_two">
            <div class="section_inner">
                <div class="oh_container">
                    <?php
                        if( !empty( $section_title ) ) :
                            ?>
                            <div class="section_title">
                                <h2>
                                    <?php
                                        echo esc_html( $section_title );
                                    ?>
                                </h2>
                            </div><!-- .section_title -->
                            <?php
                        endif;

                        if( !empty( $section_desc ) ) :
                            ?>
                            <div class="section_desc">
                                <p>
                                    <?php
                                        echo esc_html( $section_desc );
                                    ?>
                                </p>
                            </div><!-- .section_desc -->
                            <?php
                        endif;
                    ?>
                    <div class="section_content">
                        <div class="owl-carousel owl-theme blog_layout_two_carousel">
                            <?php
                                while( $blog_query->have_posts() ) :
                                    $blog_query->the_post();
                                    ?>
                                    <div class="item">
                                        <div class="card">
                                            <?php
                                                if( has_post_thumbnail() ) :
                                                    ?>
                                                    <div class="card_fimage">

                                                        <a href="<?php the_permalink(); ?>">
                                                        <?php
                                                            the_post_thumbnail( 'one-hive-thumbnail-1', array( 'alt' => the_title_attribute( array( 'echo' => false ) ), 'class' => 'img-responsive' ) );
                                                        ?>
                                                        </a>
                                                    </div><!-- .card_fimage -->
                                                    <?php
                                                endif;
                                            ?>
                                            <div class="card_content_holder">
                                                <div class="card_meta clearfix">
                                                    <?php
                                                        one_hive_get_post_author();

                                                        one_hive_get_post_date();
                                                    ?>
                                                </div><!-- .card_post_date -->
                                                <div class="card_title">
                                                    <h3>
                                                        <a href="<?php the_permalink(); ?>">
                                                            <?php
                                                                the_title();
                                                            ?>
                                                        </a>
                                                    </h3>
                                                </div><!-- .card_title -->
                                                <div class="card_desc">
                                                    <?php
                                                        the_excerpt();
                                                    ?>
                                                </div><!-- .card desc -->
                                                <div class="card_extra_metas">
                                                    <?php
                                                        one_hive_get_categories();
                                                    ?>
                                                </div><!-- .card_extra_metas -->
                                            </div><!-- .card_content_holder -->
                                        </div><!-- .card -->
                                    </div><!-- .item -->
                                    <?php
                                endwhile;
                                wp_reset_postdata();
                            ?>
                        </div>
                        <!-- // owl-carousel blog_layout_two_carousel -->
                    </div>
                    <!-- // section_content -->
                </div><!-- .oh_container -->
            </div><!-- .section_inner -->
        </section><!---->
        <?php
    endif;
?>