<?php
/**
 * Template part for displaying banner section
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */
	$enable_banner_section = one_hive_get_option( 'one_hive_enable_banner_section' );

	$section_id = one_hive_get_option( 'one_hive_banner_section_id' );

	$banner_page = one_hive_get_option( 'one_hive_banner_page' );

	$banner_args = array();

	$banner_args = array();
	                			
	if( absint( $banner_page ) > 0  ) {
		$banner_args['post_type'] = 'page';
		$banner_args['page_id'] = absint( $banner_page );
	}

	$banner_query = new WP_Query( $banner_args );

	if( $banner_query->have_posts() && $enable_banner_section == 1 ) :

		while( $banner_query->have_posts() ) :

			$banner_query->the_post();

			?>
			<div id="<?php echo esc_attr( $section_id ); ?>" class="banner_wrapper banner_wrapper_layout_one">
				<?php if( has_post_thumbnail() ) : ?>
		        <div class="banner_inner" style="background-image: url(<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ); ?>);">
		        <?php else : ?>
		        	<div class="banner_inner">
		        <?php endif; ?>
		            <div class="mask"></div>
		            <div class="oh_container">
		                <div class="banner_content_holder">
		                    <div class="row">
		                        <div class="col-md-8 col-sm-8 col-xs-12">
		                            <div class="left_side_content">
		                                <div class="banner_title">
		                                    <h2>
		                                    	<?php
		                                    		the_title();
		                                    	?>
		                                    </h2>
		                                </div><!-- .banner_title -->
		                                <div class="banner_desc">
		                                    <?php
		                                    	the_content();
		                                    ?>
		                                </div><!-- .banner_desc -->
		                            </div><!-- .left_side_content -->
		                        </div><!-- .col-* -->
		                    </div><!-- .row -->
		                </div><!-- .banner_content_holder -->
		            </div><!-- .oh_container -->
		        </div><!-- .banner_inner -->
		    </div><!-- #<?php echo esc_attr( $section_id ); ?>.banner_wrapper_layout_one -->
			<?php

		endwhile;

		wp_reset_postdata();

	endif;
?>