<?php
/**
 * One Hive Initialize
 *
 * @package One_Hive
 */

/**
 * Theme Setup Function
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/theme-functions/theme-setup.php';

/**
 * Theme Scripts Enqueue
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/theme-functions/theme-scripts.php';

/**
 * Implement the Custom Header feature.
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/core/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/core/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/core/inc/template-functions.php';

/**
 * Customizer additions.
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/core/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require_once trailingslashit( get_template_directory() ) . '/themebeez/core/inc/jetpack.php';
}

/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/themebeez/woocommerce/woocommerce.php';
}

/**
 * Load theme hooks
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/theme-functions/hooks.php';

/**
 * Load theme filters
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/theme-functions/filters.php';

/**
 * Load helper functions
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/theme-functions/helpers.php';

/**
 * Load Breadcrumb
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/third-party/breadcrumbs.php';

/**
 * Load TGM Plugin Activation
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/third-party/class-tgm-plugin-activation.php';

/**
 * Load Customizer
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/customizer-init.php';

/**
 * Load Widgets
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/widget/widget-init.php';

/**
 * Load Meta Box
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/theme-meta/post-meta.php';
require_once trailingslashit( get_template_directory() ) . '/themebeez/theme-meta/page-meta.php';