<?php
/**
 * Customizer Option - Others
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();

$sidebar_choices = one_hive_get_sidebar_choices();

// Section - Header
$wp_customize->add_section( 'one_hive_other_options', array(
	'priority'		=> 20,
	'title'			=> esc_html__( 'Others', 'one-hive' ),
	'panel'			=> 'one_hive_theme_options'	
) );

// Excerpt Length
$wp_customize->add_setting( 'one_hive_archive_excerpt_length', array(
	'sanitize_callback'	=> 'one_hive_sanitize_number',
	'default'			=> $defaults['one_hive_archive_excerpt_length'],
) );

$wp_customize->add_control( 'one_hive_archive_excerpt_length', array(
	'label'				=> esc_html__( 'Excerpt Length', 'one-hive' ),
	'section'			=> 'one_hive_other_options',
	'type'				=> 'number',
) );

// Sidebar Position
$wp_customize->add_setting( 'one_hive_global_sidebar_choice', array(
	'sanitize_callback'	=> 'one_hive_sanitize_select',
	'default'			=> $defaults['one_hive_global_sidebar_choice'],
) );

$wp_customize->add_control( 'one_hive_global_sidebar_choice', array(
	'label'				=> esc_html__( 'Sidebar Position', 'one-hive' ),
	'section'			=> 'one_hive_other_options',
	'type'				=> 'radio',
	'choices' 			=> $sidebar_choices
) );