<?php
/**
 * Customizer Options - Footer
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();


// Section - Footer
$wp_customize->add_section( 'one_hive_footer_options', array(
	'priority'		=> 20,
	'title'			=> esc_html__( 'Footer', 'one-hive' ),
	'description'	=> esc_html__( 'Configurations of footer', 'one-hive' ),
	'panel'			=> 'one_hive_theme_options'	
) );

// Enable Bottom Footer
$wp_customize->add_setting( 'one_hive_enable_footer_bottom', array(
	'sanitize_callback'	=> 'one_hive_sanitize_checkbox',
	'default'			=> $defaults['one_hive_enable_footer_bottom'],
) );
$wp_customize->add_control( 'one_hive_enable_footer_bottom', array(
	'label'				=> esc_html__( 'Enable Bottom Footer', 'one-hive' ),
	'section'			=> 'one_hive_footer_options',
	'type'				=> 'checkbox' 
) );

// Copyright Text
$wp_customize->add_setting( 'one_hive_footer_copyright_text', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_footer_copyright_text'],
) );
$wp_customize->add_control( 'one_hive_footer_copyright_text', array(
	'label'				=> esc_html__( 'Copyright Text', 'one-hive' ),
	'section'			=> 'one_hive_footer_options',
	'type'				=> 'text',
) );