<?php
/**
 * Customizer Options - Contact Info
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();

// Section - Contact Info
$wp_customize->add_section( 'one_hive_contact_option', array(
	'priority'		=> 20,
	'title'			=> esc_html__( 'Contact Info', 'one-hive' ),
	'panel'			=> 'one_hive_theme_options'	
) );

// Phone No
$wp_customize->add_setting( 'one_hive_phone_no', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_phone_no'],
) );
$wp_customize->add_control( 'one_hive_phone_no', array(
	'label'				=> esc_html__( 'Phone Number', 'one-hive' ),
	'section'			=> 'one_hive_contact_option',
	'type'				=> 'text',
) );

// Email Address
$wp_customize->add_setting( 'one_hive_email', array(
	'sanitize_callback'	=> 'sanitize_email',
	'default'			=> $defaults['one_hive_email'],
) );
$wp_customize->add_control( 'one_hive_email', array(
	'label'				=> esc_html__( 'Email Address', 'one-hive' ),
	'section'			=> 'one_hive_contact_option',
	'type'				=> 'text',
) );

// Physical Address
$wp_customize->add_setting( 'one_hive_location', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_location'],
) );
$wp_customize->add_control( 'one_hive_location', array(
	'label'				=> esc_html__( 'Physical Address', 'one-hive' ),
	'section'			=> 'one_hive_contact_option',
	'type'				=> 'text',
) );