<?php
/**
 * Customizer Options Initialization
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();

$site_choices = one_hive_get_site_option();

// Section - Site
$wp_customize->add_section( 'one_hive_site_option', array(
	'priority'		=> 2,
	'title'			=> esc_html__( 'Site Option', 'one-hive' ),
	'panel'			=> ''	
) );

// Activate Front Page
$wp_customize->add_setting( 'one_hive_active_home_page', array(
	'sanitize_callback'	=> 'one_hive_sanitize_checkbox',
	'default'			=> $defaults['one_hive_active_home_page'],
) );

$wp_customize->add_control( 'one_hive_active_home_page', array(
	'label'				=> esc_html__( 'Active Front Page', 'one-hive' ),
	'description'		=> esc_html__( 'By default Front Page is inactive. To set Front Page as default home page, enable it.', 'one-hive' ),
	'section'			=> 'one_hive_site_option',
	'type'				=> 'checkbox',
) );

// Site Type
$wp_customize->add_setting( 'one_hive_site_choice', array(
	'sanitize_callback'	=> 'one_hive_sanitize_select',
	'default'			=> $defaults['one_hive_site_choice'],
) );

$wp_customize->add_control( 'one_hive_site_choice', array(
	'label'				=> esc_html__( 'Site Type', 'one-hive' ),
	'description'		=> esc_html__( 'Choose how your site behave. Select "One Page" option use the site as one page site. If you want to use your site as multipage site, then select "Multi Page" option.', 'one-hive' ),
	'section'			=> 'one_hive_site_option',
	'type'				=> 'select',
	'choices' 			=> $site_choices,
	'active_callback'	=> 'one_hive_is_active_home_page'
) );

$wp_customize->add_panel( 'one_hive_theme_options', array(
	'title'			=> esc_html__( 'Theme Options', 'one-hive' ),
	'description'	=> esc_html__( 'One Hive Customization', 'one-hive' ),
	'priority'		=> 10	
) );

$wp_customize->add_panel( 'one_hive_home_page_options', array(
	'title'			=> esc_html__( 'Home Page Options', 'one-hive' ),
	'description'	=> esc_html__( 'One Hive Home Page Customization', 'one-hive' ),
	'priority'		=> 10	
) );

/**
 * 	Load Options
 */
require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/home-options/option-banner.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/home-options/option-feature.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/home-options/option-team.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/home-options/option-news.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/home-options/option-testimonial.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/home-options/option-blog.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/home-options/option-cta.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/home-options/option-partner.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/home-options/option-contact.php';



require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/theme-options/option-header.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/theme-options/option-footer.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/theme-options/option-archive.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/theme-options/option-single.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/theme-options/option-contact.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/theme-options/option-links.php';

require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/theme-options/option-others.php';

