<?php
/**
 * Option Functions
 *
 * @package One_Hive
 */

if( !function_exists( 'one_hive_get_site_option' ) ) :
	/*
	 * Function to get site option
	 */
	function one_hive_get_site_option() {

		$site_options = array(
			'one_page'	=> esc_html__( 'One Page', 'one-hive' ),
			'multi_page' => esc_html__( 'Multi Page', 'one-hive' ),
		);

		return $site_options;

	}
endif;

if( !function_exists( 'one_hive_get_pages' ) ) :
	/*
	 * Function to get pages
	 */
	function one_hive_get_pages() {

		$pages  =  get_pages();
		$page_list = array();
		$page_list[0] = esc_html__( 'Select Page', 'one-hive' );

		foreach( $pages as $page ){
			$page_list[ $page->ID ] = $page->post_title;
		}

		return $page_list;

	}
endif;

if( !function_exists( 'one_hive_get_blog_cat' ) ) :
	/*
	 * Function to get blog categories
	 */
	function one_hive_get_blog_cat() {

		$taxonomy = 'category';

		$terms = get_terms( $taxonomy );

		$blog_cat = array();

		foreach( $terms as $term ) {
			$blog_cat[$term->term_id] = $term->name;
		}

		return $blog_cat;

	}
endif;

if( !function_exists( 'one_hive_get_sidebar_choices' ) ) :
	/*
	 * Function to page_layout choices
	 */
	function one_hive_get_sidebar_choices() {

		$sidebar_choices = array(
			'right' => esc_html__( 'Right Sidebar', 'one-hive' ),
			'left' => esc_html__( 'Left Sidebar', 'one-hive' ),
			'none' => esc_html__( 'No Sidebar', 'one-hive' ),
		);

		return $sidebar_choices;

	}
endif;

