<?php
/**
 * Customizer Option - Testimonial
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();

$pages = one_hive_get_pages();

// Section - Testimonial
$wp_customize->add_section( 'one_hive_testimonial_section', array(
	'priority'		=> 20,
	'title'			=> esc_html__( 'Testimonial Section', 'one-hive' ),
	'panel'			=> 'one_hive_home_page_options'	
) );

// Enable Testimonial
$wp_customize->add_setting( 'one_hive_enable_testimonial_section', array(
	'sanitize_callback'	=> 'one_hive_sanitize_checkbox',
	'default'			=> $defaults['one_hive_enable_testimonial_section'],
) );

$wp_customize->add_control( 'one_hive_enable_testimonial_section', array(
	'label'				=> esc_html__( 'Enable Testimonial Section', 'one-hive' ),
	'section'			=> 'one_hive_testimonial_section',
	'type'				=> 'checkbox',
) );

// Testimonial Section ID
$wp_customize->add_setting( 'one_hive_testimonial_section_id', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_testimonial_section_id'],
) );

$wp_customize->add_control( 'one_hive_testimonial_section_id', array(
	'label'				=> esc_html__( 'Testimonial Section ID', 'one-hive' ),
	'description'		=> esc_html__( 'Testimonial Section ID is used to navigate to testimonial section from Menu Item. It will be active when your site is one page site.', 'one-hive' ),
	'section'			=> 'one_hive_testimonial_section',
	'type'				=> 'text',
	'active_callback'	=> 'one_hive_enable_testimonial_section_id'
) );

// Testimonial Section Title
$wp_customize->add_setting( 'one_hive_testimonial_section_title', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_testimonial_section_title'],
) );

$wp_customize->add_control( 'one_hive_testimonial_section_title', array(
	'label'				=> esc_html__( 'Testimonial Section Title', 'one-hive' ),
	'section'			=> 'one_hive_testimonial_section',
	'active_callback'	=> 'one_hive_is_active_testimonial_section'
) );

// Testimonial Section Description
$wp_customize->add_setting( 'one_hive_testimonial_section_description', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_testimonial_section_description'],
) );

$wp_customize->add_control( 'one_hive_testimonial_section_description', array(
	'label'				=> esc_html__( 'Testimonial Section Description', 'one-hive' ),
	'section'			=> 'one_hive_testimonial_section',
	'active_callback'	=> 'one_hive_is_active_testimonial_section'
) );

// Testimonials
$wp_customize->add_setting( 'one_hive_testimonial_contents', array(
	'sanitize_callback' => 'one_hive_repeater_data_field',
	'transport' => 'postMessage',
) );

$wp_customize->add_control( new One_Hive_Repeater_Control( $wp_customize, 'one_hive_testimonial_contents', array(
    'label' 		=> esc_html__('Testimonials', 'one-hive'),
    'description'   => '',
    'section'       => 'one_hive_testimonial_section',
    'live_title_id' => '', // apply for unput text and textarea only
    'title_format'  => '', // [live_title]
    'max_item'      => 3, // Maximum item can add
    'limited_msg' 	=> esc_html__( 'Only three testinomial items can be set.', 'one-hive' ),
    'fields'    	=> array(
    	'one_hive_client_page'  => array(
        	'title' => esc_html__('Page of Client', 'one-hive'),
        	'type'  => 'select',
        	'options' => $pages
        ),
    ),
    'active_callback'	=> 'one_hive_is_active_testimonial_section'
) ) );
