<?php
/**
 * Customizer Option - Team
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();

$pages = one_hive_get_pages();

// Section - Team
$wp_customize->add_section( 'one_hive_team_section', array(
	'priority'		=> 20,
	'title'			=> esc_html__( 'Team Section', 'one-hive' ),
	'panel'			=> 'one_hive_home_page_options'	
) );

// Enable Team
$wp_customize->add_setting( 'one_hive_enable_team_section', array(
	'sanitize_callback'	=> 'one_hive_sanitize_checkbox',
	'default'			=> $defaults['one_hive_enable_team_section'],
) );

$wp_customize->add_control( 'one_hive_enable_team_section', array(
	'label'				=> esc_html__( 'Enable Team Section', 'one-hive' ),
	'section'			=> 'one_hive_team_section',
	'type'				=> 'checkbox',
) );

// Team Section ID
$wp_customize->add_setting( 'one_hive_team_section_id', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_team_section_id'],
) );

$wp_customize->add_control( 'one_hive_team_section_id', array(
	'label'				=> esc_html__( 'Team Section ID', 'one-hive' ),
	'description'		=> esc_html__( 'Team Section ID is used to navigate to team section from Menu Item. It will be active when your site is one page site.', 'one-hive' ),
	'section'			=> 'one_hive_team_section',
	'type'				=> 'text',
	'active_callback'	=> 'one_hive_enable_team_section_id'
) );

// Team Section Title
$wp_customize->add_setting( 'one_hive_team_section_title', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_team_section_title'],
) );

$wp_customize->add_control( 'one_hive_team_section_title', array(
	'label'				=> esc_html__( 'Team Section Title', 'one-hive' ),
	'section'			=> 'one_hive_team_section',
	'active_callback'	=> 'one_hive_is_active_team_section'
) );

// Team Section Description
$wp_customize->add_setting( 'one_hive_team_section_description', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_team_section_description'],
) );

$wp_customize->add_control( 'one_hive_team_section_description', array(
	'label'				=> esc_html__( 'Team Section Description', 'one-hive' ),
	'section'			=> 'one_hive_team_section',
	'active_callback'	=> 'one_hive_is_active_team_section'
) );

// Team Members
$wp_customize->add_setting( 'one_hive_team_contents', array(
	'sanitize_callback' => 'one_hive_repeater_data_field',
	'transport' => 'postMessage',
) );

$wp_customize->add_control( new One_Hive_Repeater_Control( $wp_customize, 'one_hive_team_contents', array(
    'label' 		=> esc_html__('Members', 'one-hive'),
    'description'   => '',
    'section'       => 'one_hive_team_section',
    'live_title_id' => '', // apply for unput text and textarea only
    'title_format'  => '', // [live_title]
    'max_item'      => 4, // Maximum item can add
    'limited_msg' 	=> esc_html__( 'Only 4 team members can be set.', 'one-hive' ),
    'fields'    => array(
    	'one_hive_team_page'  => array(
        	'title' => esc_html__('Team Page', 'one-hive'),
        	'type'  => 'select',
        	'options' => $pages
        ),
    ),
    'active_callback'	=> 'one_hive_is_active_team_section'
) ) );

