<?php
/**
 * Customizer Option - Partner
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();

$pages = one_hive_get_pages();

// Section - Partner
$wp_customize->add_section( 'one_hive_partner_section', array(
	'priority'		=> 20,
	'title'			=> esc_html__( 'Partner Section', 'one-hive' ),
	'panel'			=> 'one_hive_home_page_options'	
) );

// Enable Partner
$wp_customize->add_setting( 'one_hive_enable_partner_section', array(
	'sanitize_callback'	=> 'one_hive_sanitize_checkbox',
	'default'			=> $defaults['one_hive_enable_partner_section'],
) );

$wp_customize->add_control( 'one_hive_enable_partner_section', array(
	'label'				=> esc_html__( 'Enable Partner Section', 'one-hive' ),
	'section'			=> 'one_hive_partner_section',
	'type'				=> 'checkbox',
) );

// Partner Section ID
$wp_customize->add_setting( 'one_hive_partner_section_id', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_partner_section_id'],
) );

$wp_customize->add_control( 'one_hive_partner_section_id', array(
	'label'				=> esc_html__( 'Partner Section ID', 'one-hive' ),
	'description'		=> esc_html__( 'Partner Section ID is used to navigate to partner section from Menu Item. It will be active when your site is one page site.', 'one-hive' ),
	'section'			=> 'one_hive_partner_section',
	'type'				=> 'text',
	'active_callback'	=> 'one_hive_enable_partner_section_id'
) );


// Partner Section Title
$wp_customize->add_setting( 'one_hive_partner_section_title', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_partner_section_title'],
) );

$wp_customize->add_control( 'one_hive_partner_section_title', array(
	'label'				=> esc_html__( 'Partner Section Title', 'one-hive' ),
	'section'			=> 'one_hive_partner_section',
	'active_callback'	=> 'one_hive_is_active_partner_section'
) );

// Partner Section Description
$wp_customize->add_setting( 'one_hive_partner_section_description', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_partner_section_description'],
) );

$wp_customize->add_control( 'one_hive_partner_section_description', array(
	'label'				=> esc_html__( 'Partner Section Description', 'one-hive' ),
	'section'			=> 'one_hive_partner_section',
	'active_callback'	=> 'one_hive_is_active_partner_section'
) );

// Partners
$wp_customize->add_setting( 'one_hive_partner_contents', array(
	'sanitize_callback' => 'one_hive_repeater_data_field',
	'transport' => 'postMessage',
) );

$wp_customize->add_control( new One_Hive_Repeater_Control( $wp_customize, 'one_hive_partner_contents', array(
    'label' 		=> esc_html__('Partners', 'one-hive'),
    'description'   => '',
    'section'       => 'one_hive_partner_section',
    'live_title_id' => '', // apply for unput text and textarea only
    'title_format'  => '', // [live_title]
    'max_item'      => 6, // Maximum item can add
    'limited_msg' 	=> esc_html__( 'Only 6 items can be set.', 'one-hive' ),
    'fields'    	=> array(
    	'one_hive_partner_page'  => array(
        	'title' => esc_html__( 'Partner Page', 'one-hive' ),
        	'type'  => 'select',
        	'options' => $pages
        ),
    ),
    'active_callback'	=> 'one_hive_is_active_partner_section'
) ) );