<?php
/**
 * Customizer Option - Features
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();

$pages = one_hive_get_pages();

// Section - Feature
$wp_customize->add_section( 'one_hive_feature_section', array(
	'priority'		=> 20,
	'title'			=> esc_html__( 'Feature Section', 'one-hive' ),
	'description'	=> esc_html__( 'This section can be used for either to list out features or services.', 'one-hive' ),
	'panel'			=> 'one_hive_home_page_options'	
) );

// Enable Feature
$wp_customize->add_setting( 'one_hive_enable_feature_section', array(
	'sanitize_callback'	=> 'one_hive_sanitize_checkbox',
	'default'			=> $defaults['one_hive_enable_feature_section'],
) );

$wp_customize->add_control( 'one_hive_enable_feature_section', array(
	'label'				=> esc_html__( 'Enable Feature Section', 'one-hive' ),
	'section'			=> 'one_hive_feature_section',
	'type'				=> 'checkbox',
) );

// Feature Section ID
$wp_customize->add_setting( 'one_hive_feature_section_id', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_feature_section_id'],
) );

$wp_customize->add_control( 'one_hive_feature_section_id', array(
	'label'				=> esc_html__( 'Feature Section ID', 'one-hive' ),
	'description'		=> esc_html__( 'Feature Section ID is used to navigate to feature section from Menu Item. It will be active when your site is one page site.', 'one-hive' ),
	'section'			=> 'one_hive_feature_section',
	'type'				=> 'text',
	'active_callback'	=> 'one_hive_enable_feature_section_id'
) );

// Feature Section Title
$wp_customize->add_setting( 'one_hive_feature_section_title', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_feature_section_title'],
) );

$wp_customize->add_control( 'one_hive_feature_section_title', array(
	'label'				=> esc_html__( 'Feature Section Title', 'one-hive' ),
	'section'			=> 'one_hive_feature_section',
	'active_callback'	=> 'one_hive_is_active_feature_section'
) );

// Feature Section Description
$wp_customize->add_setting( 'one_hive_feature_section_description', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_feature_section_description'],
) );

$wp_customize->add_control( 'one_hive_feature_section_description', array(
	'label'				=> esc_html__( 'Feature Section Description', 'one-hive' ),
	'section'			=> 'one_hive_feature_section',
	'active_callback'	=> 'one_hive_is_active_feature_section'
) );

// Features
$wp_customize->add_setting( 'one_hive_feature_contents', array(
	'sanitize_callback' => 'one_hive_repeater_data_field',
	'transport' => 'postMessage',
) );

$wp_customize->add_control( new One_Hive_Repeater_Control( $wp_customize, 'one_hive_feature_contents', array(
    'label' 		=> esc_html__('Features', 'one-hive'),
    'description'   => '',
    'section'       => 'one_hive_feature_section',
    'live_title_id' => '', // apply for unput text and textarea only
    'title_format'  => '', // [live_title]
    'max_item'      => 6, // Maximum item can add
    'limited_msg' 	=> esc_html__( 'Only 6 features can be added.', 'one-hive' ),
    'fields'    	=> array(
    	'one_hive_feature_page'  => array(
        	'title' => esc_html__('Feature Page', 'one-hive'),
        	'type'  => 'select',
        	'options' => $pages
        ),
        'one_hive_feature_icon'  => array(
        	'title' => esc_html__('Feature Icon', 'one-hive'),
        	'type'  => 'icon',
        ),
    ),
    'active_callback'	=> 'one_hive_is_active_feature_section'
) ) );
