<?php
/**
 * Customizer Option - CTA
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();

$pages = one_hive_get_pages();

// Section - CTA
$wp_customize->add_section( 'one_hive_cta_section', array(
	'priority'		=> 20,
	'title'			=> esc_html__( 'CTA Section', 'one-hive' ),
	'panel'			=> 'one_hive_home_page_options'	
) );

// Enable CTA
$wp_customize->add_setting( 'one_hive_enable_cta_section', array(
	'sanitize_callback'	=> 'one_hive_sanitize_checkbox',
	'default'			=> $defaults['one_hive_enable_cta_section'],
) );

$wp_customize->add_control( 'one_hive_enable_cta_section', array(
	'label'				=> esc_html__( 'Enable CTA Section', 'one-hive' ),
	'section'			=> 'one_hive_cta_section',
	'type'				=> 'checkbox',
) );

// CTA Section ID
$wp_customize->add_setting( 'one_hive_cta_section_id', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_cta_section_id'],
) );

$wp_customize->add_control( 'one_hive_cta_section_id', array(
	'label'				=> esc_html__( 'CTA Section ID', 'one-hive' ),
	'description'		=> esc_html__( 'CTA Section ID is used to navigate to CTA section from Menu Item. It will be active when your site is one page site.', 'one-hive' ),
	'section'			=> 'one_hive_cta_section',
	'type'				=> 'text',
	'active_callback'	=> 'one_hive_enable_cta_section_id'
) );

// CTA Page
$wp_customize->add_setting( 'one_hive_cta_page', array(
	'sanitize_callback'	=> 'one_hive_sanitize_dropdown_pages',
	'default'			=> $defaults['one_hive_cta_page'],
) );

$wp_customize->add_control( 'one_hive_cta_page', array(
	'label'				=> esc_html__( 'CTA Page', 'one-hive' ),
	'description'		=> esc_html__( 'Page Contents are used for the image and CTA content', 'one-hive' ),
	'section'			=> 'one_hive_cta_section',
	'type'				=> 'select',
	'choices'			=> $pages,
	'active_callback'	=> 'one_hive_is_active_cta_section'
) );