<?php
/**
 * Customizer Option - Contact
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();

$pages = one_hive_get_pages();

// Section - Contact
$wp_customize->add_section( 'one_hive_contact_section', array(
	'priority'		=> 20,
	'title'			=> esc_html__( 'Contact Section', 'one-hive' ),
	'panel'			=> 'one_hive_home_page_options'	
) );

// Enable Contact
$wp_customize->add_setting( 'one_hive_enable_contact_section', array(
	'sanitize_callback'	=> 'one_hive_sanitize_checkbox',
	'default'			=> $defaults['one_hive_enable_contact_section'],
) );

$wp_customize->add_control( 'one_hive_enable_contact_section', array(
	'label'				=> esc_html__( 'Enable Contact Section', 'one-hive' ),
	'section'			=> 'one_hive_contact_section',
	'type'				=> 'checkbox',
) );

// Contact Section ID
$wp_customize->add_setting( 'one_hive_contact_section_id', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_contact_section_id'],
) );

$wp_customize->add_control( 'one_hive_contact_section_id', array(
	'label'				=> esc_html__( 'Contact Section ID', 'one-hive' ),
	'description'		=> esc_html__( 'Contact Section ID is used to navigate to contact section from Menu Item. It will be active when your site is one page site.', 'one-hive' ),
	'section'			=> 'one_hive_contact_section',
	'type'				=> 'text',
	'active_callback'	=> 'one_hive_enable_contact_section_id'
) );

// Contact Section Title
$wp_customize->add_setting( 'one_hive_contact_section_title', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_contact_section_title'],
) );

$wp_customize->add_control( 'one_hive_contact_section_title', array(
	'label'				=> esc_html__( 'Contact Section Title', 'one-hive' ),
	'section'			=> 'one_hive_contact_section',
	'active_callback'	=> 'one_hive_is_active_contact_section'
) );

// Contact Section Description
$wp_customize->add_setting( 'one_hive_contact_section_description', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_contact_section_description'],
) );

$wp_customize->add_control( 'one_hive_contact_section_description', array(
	'label'				=> esc_html__( 'Contact Section Description', 'one-hive' ),
	'section'			=> 'one_hive_contact_section',
	'active_callback'	=> 'one_hive_is_active_contact_section'
) );

// Contact Form
$wp_customize->add_setting( 'one_hive_contact_form_shortcode', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_contact_form_shortcode'],
) );

$wp_customize->add_control( 'one_hive_contact_form_shortcode', array(
	'label'				=> esc_html__( 'Contact Form Shortcode', 'one-hive' ),
	'section'			=> 'one_hive_contact_section',
	'active_callback'	=> 'one_hive_is_active_contact_section'
) );