<?php
/**
 * Customizer Option - Blog
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();

// Section - Blog
$wp_customize->add_section( 'one_hive_blog_section', array(
	'priority'		=> 20,
	'title'			=> esc_html__( 'Blog Section', 'one-hive' ),
	'panel'			=> 'one_hive_home_page_options'	
) );

// Enable Blog
$wp_customize->add_setting( 'one_hive_enable_blog_section', array(
	'sanitize_callback'	=> 'one_hive_sanitize_checkbox',
	'default'			=> $defaults['one_hive_enable_blog_section'],
) );

$wp_customize->add_control( 'one_hive_enable_blog_section', array(
	'label'				=> esc_html__( 'Enable Blog Section', 'one-hive' ),
	'section'			=> 'one_hive_blog_section',
	'type'				=> 'checkbox',
) );

// Blog Section ID
$wp_customize->add_setting( 'one_hive_blog_section_id', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_blog_section_id'],
) );

$wp_customize->add_control( 'one_hive_blog_section_id', array(
	'label'				=> esc_html__( 'Blog Section ID', 'one-hive' ),
	'description'		=> esc_html__( 'Blog Section ID is used to navigate to blog section from Menu Item. It will be active when your site is one page site.', 'one-hive' ),
	'section'			=> 'one_hive_blog_section',
	'type'				=> 'text',
	'active_callback'		=> 'one_hive_enable_blog_section_id'
) );

// Blog Section Title
$wp_customize->add_setting( 'one_hive_blog_section_title', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_blog_section_title'],
) );

$wp_customize->add_control( 'one_hive_blog_section_title', array(
	'label'				=> esc_html__( 'Blog Section Title', 'one-hive' ),
	'section'			=> 'one_hive_blog_section',
	'active_callback'		=> 'one_hive_is_active_blog_section'
) );

// Blog Section Description
$wp_customize->add_setting( 'one_hive_blog_section_description', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_blog_section_description'],
) );

$wp_customize->add_control( 'one_hive_blog_section_description', array(
	'label'				=> esc_html__( 'Blog Section Description', 'one-hive' ),
	'section'			=> 'one_hive_blog_section',
	'active_callback'		=> 'one_hive_is_active_blog_section'
) );

// Blog Post Category
$wp_customize->add_setting( 'one_hive_blog_post_category', array(
	'sanitize_callback'	=> 'one_hive_sanitize_choices',
) );

$wp_customize->add_control( new One_Hive_Dropdown_Multiple_Chooser( $wp_customize, 'one_hive_blog_post_category', array(
	'label'				=> esc_html__( 'Blog Post Category', 'one-hive' ),
	'description'		=> esc_html__( 'Select one or more than one categories', 'one-hive' ),
	'section'			=> 'one_hive_blog_section',
	'type'				=> 'select',
	'choices'			=> one_hive_get_blog_cat(),
	'active_callback'		=> 'one_hive_is_active_blog_section'
) ) );

// Blog Posts Number
$wp_customize->add_setting( 'one_hive_blog_posts_number', array(
	'sanitize_callback'		=> 'one_hive_sanitize_number',
	'default'				=> $defaults['one_hive_blog_posts_number'] 
) ); 

$wp_customize->add_control( 'one_hive_blog_posts_number', array(
	'label'					=> esc_html__( 'Numbers of Blog Posts', 'one-hive' ),
	'section'				=> 'one_hive_blog_section',
	'type'					=> 'number',
	'active_callback'		=> 'one_hive_is_active_blog_section'
) );