<?php
/**
 * Customizer Option - Banner
 *
 * @package One_Hive
 */

$defaults = one_hive_get_default_theme_options();

$pages = one_hive_get_pages();

// Section - Header
$wp_customize->add_section( 'one_hive_banner_section', array(
	'priority'		=> 20,
	'title'			=> esc_html__( 'Banner Section', 'one-hive' ),
	'panel'			=> 'one_hive_home_page_options'	
) );

// Enable Banner
$wp_customize->add_setting( 'one_hive_enable_banner_section', array(
	'sanitize_callback'	=> 'one_hive_sanitize_checkbox',
	'default'			=> $defaults['one_hive_enable_banner_section'],
) );

$wp_customize->add_control( 'one_hive_enable_banner_section', array(
	'label'				=> esc_html__( 'Enable Banner', 'one-hive' ),
	'section'			=> 'one_hive_banner_section',
	'type'				=> 'checkbox',
) );

// Banner Section ID
$wp_customize->add_setting( 'one_hive_banner_section_id', array(
	'sanitize_callback'	=> 'sanitize_text_field',
	'default'			=> $defaults['one_hive_banner_section_id'],
) );

$wp_customize->add_control( 'one_hive_banner_section_id', array(
	'label'				=> esc_html__( 'Banner Section ID', 'one-hive' ),
	'description'		=> esc_html__( 'Banner Section ID is used to navigate to banner section from Menu Item. It will be active when your site is one page site.', 'one-hive' ),
	'section'			=> 'one_hive_banner_section',
	'type'				=> 'text',
	'active_callback'	=> 'one_hive_enable_banner_section_id'
) );

// Banner Page
$wp_customize->add_setting( 'one_hive_banner_page', array(
	'sanitize_callback'	=> 'one_hive_sanitize_dropdown_pages',
	'default'			=> $defaults['one_hive_banner_page'],
) );

$wp_customize->add_control( 'one_hive_banner_page', array(
	'label'				=> esc_html__( 'Banner Page', 'one-hive' ),
	'description'		=> esc_html__( 'Page Contents are used for the image and banner content', 'one-hive' ),
	'section'			=> 'one_hive_banner_section',
	'type'				=> 'select',
	'choices'			=> $pages,
	'active_callback'	=> 'one_hive_is_active_banner_section'
) );