<?php
/**
 * Default Options.
 *
 * @package One_Hive
 */

if ( ! function_exists( 'one_hive_get_option' ) ) :

	/**
	 * Get theme option.
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function one_hive_get_option( $key ) {

	       if ( empty( $key ) ) {
			return;
		}

		$value = '';

		$default = one_hive_get_default_theme_options();

		$default_value = null;

		if ( is_array( $default ) && isset( $default[ $key ] ) ) {
			$default_value = $default[ $key ];
		}

		if ( null !== $default_value ) {
			$value = get_theme_mod( $key, $default_value );
		}
		else {
			$value = get_theme_mod( $key );
		}

		return $value;
	}

endif;

if ( ! function_exists( 'one_hive_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
	function one_hive_get_default_theme_options() {

        	$defaults = array();

                $defaults['one_hive_site_choice'] = 'one_page';
        	$defaults['one_hive_active_home_page'] = 0;

                // Header Section
                $defaults['one_hive_enable_top_header'] = 1;

                // Banner Section
                $defaults['one_hive_enable_banner_section'] = 1;
                $defaults['one_hive_banner_section_id'] = '';
                $defaults['one_hive_banner_page'] = 0;

                // Features Section
                $defaults['one_hive_enable_feature_section'] = 1;
                $defaults['one_hive_feature_section_id'] = '';
                $defaults['one_hive_feature_section_title'] = '';
                $defaults['one_hive_feature_section_description'] = '';

                // Counter Section
                $defaults['one_hive_enable_counter_section'] = 1;
                $defaults['one_hive_counter_section_id'] = '';
                $defaults['one_hive_counter_image_background'] = '';

                // Team Section
                $defaults['one_hive_enable_team_section'] = 1;
                $defaults['one_hive_team_section_id'] = '';
                $defaults['one_hive_team_section_title'] = '';
                $defaults['one_hive_team_section_description'] = '';

                // News Section
                $defaults['one_hive_enable_news_section'] = 1;
                $defaults['one_hive_news_section_id'] = '';
                $defaults['one_hive_news_section_title'] = '';
                $defaults['one_hive_news_section_description'] = '';
                $defaults['one_hive_news_posts_number'] = 5;

                // Testimonial Section
                $defaults['one_hive_enable_testimonial_section'] = 1;
                $defaults['one_hive_testimonial_section_id'] = '';
                $defaults['one_hive_testimonial_section_title'] = '';
                $defaults['one_hive_testimonial_section_description'] = '';

                // Blog Section
                $defaults['one_hive_enable_blog_section'] = 1;
                $defaults['one_hive_blog_section_id'] = '';
                $defaults['one_hive_blog_section_title'] = '';
                $defaults['one_hive_blog_section_description'] = '';
                $defaults['one_hive_blog_posts_number'] = 5;

                // CTA Section
                $defaults['one_hive_enable_cta_section'] = 1;
                $defaults['one_hive_cta_section_id'] = '';
                $defaults['one_hive_cta_page'] = 0;

                // Partner Section
                $defaults['one_hive_enable_partner_section'] = 1;
                $defaults['one_hive_partner_section_id'] = '';
                $defaults['one_hive_partner_section_title'] = '';
                $defaults['one_hive_partner_section_description'] = '';

                // Contact Section
                $defaults['one_hive_enable_contact_section'] = 1;
                $defaults['one_hive_contact_section_id'] = '';
                $defaults['one_hive_contact_section_title'] = '';
                $defaults['one_hive_contact_section_description'] = '';
                $defaults['one_hive_contact_form_shortcode'] = '';

                // Archive
                $defaults['one_hive_archive_enable_archive_type'] = 1;

                // Single Post
                $defaults['one_hive_single_post_enable_comment'] = 1;

                // Footer
                $defaults['one_hive_enable_footer_bottom'] = 1;
                $defaults['one_hive_footer_copyright_text'] = esc_html__( 'COPYRIGHT &copy; 2018. ALL RIGHT RESERVED', 'one-hive' );

                // Others
                $defaults['one_hive_archive_excerpt_length'] = 15;
                $defaults['one_hive_global_sidebar_choice'] = 'right';

                // Social Info
                $defaults['one_hive_facebook_link'] = '';
                $defaults['one_hive_twitter_link'] = '';
                $defaults['one_hive_linkedin_link'] = '';
                $defaults['one_hive_instagram_link'] = '';
                $defaults['one_hive_dribble_link'] = '';
                $defaults['one_hive_vk_link'] = '';

                // Contact Info
                $defaults['one_hive_phone_no'] = esc_html__( '+01 (33422789)', 'one-hive' );
                $defaults['one_hive_email'] = esc_html__( 'hello@domain.com', 'one-hive' );
                $defaults['one_hive_location'] = esc_html__( 'California, USA', 'one-hive' );

        	return $defaults;

	}

endif;

