<?php

/**
 * Add customizer selective refresh
 *
 * @since 1.2.1
 *
 * @param $wp_customize
 */
function one_hive_customizer_partials( $wp_customize ) {

    // Abort if selective refresh is not available.
    if ( ! isset( $wp_customize->selective_refresh ) ) {
        return;
    }

    $selective_refresh_keys = array(

        // Feature Section
        array(
            'id' => 'feature',
            'selector' => '.features_one',
            'settings' => array(
                'one_hive_enable_feature_section',
                'one_hive_feature_section_id',
                'one_hive_feature_section_title',
                'one_hive_feature_section_description',
                'one_hive_feature_contents',
            ),
        ),

        // Team Section
        array(
            'id' => 'team',
            'selector' => '.team',
            'settings' => array(
                'one_hive_enable_team_section',
                'one_hive_team_section_id',
                'one_hive_team_section_title',
                'one_hive_team_section_description',
                'one_hive_team_contents',
            ),
        ),

        // News Section
        array(
            'id' => 'news',
            'selector' => '.blog_layout_one',
            'settings' => array(
                'one_hive_enable_news_section',
                'one_hive_news_section_id',
                'one_hive_news_section_title',
                'one_hive_news_section_description',
                'one_hive_news_post_category',
                'one_hive_news_posts_number',
            ),
        ),

        // Testimonial Section
        array(
            'id' => 'testimonial',
            'selector' => '.oh_testinomial',
            'settings' => array(
                'one_hive_enable_testimonial_section',
                'one_hive_testimonial_section_id',
                'one_hive_testimonial_section_title',
                'one_hive_testimonial_section_description',
                'one_hive_testimonial_contents',
            ),
        ),        

        // Blog Section
        array(
            'id' => 'blog',
            'selector' => '.oh_blog_layout_two',
            'settings' => array(
                'one_hive_enable_blog_section',
                'one_hive_blog_section_id',
                'one_hive_blog_section_title',
                'one_hive_blog_section_description',
                'one_hive_blog_post_category',
                'one_hive_blog_posts_number',
            ),
        ),
        
        // CTA Section
        array(
            'id' => 'cta',
            'selector' => '.oh_cta',
            'settings' => array(
                'one_hive_enable_cta_section',
                'one_hive_cta_section_id',
                'one_hive_cta_page',
                'one_hive_cta_button_title',
                'one_hive_cta_button_link',
            ),
        ),

        // Partner Section
        array(
            'id' => 'partner',
            'selector' => '.oh_client',
            'settings' => array(
                'one_hive_partner_contents',
                'one_hive_enable_partner_section',
                'one_hive_partner_section_id',
                'one_hive_partner_section_title',
                'one_hive_partner_section_description'
            ),
        ),
    );

    $selective_refresh_keys = apply_filters( 'one_hive_customizer_partials_selective_refresh_keys', $selective_refresh_keys );

    foreach ( $selective_refresh_keys as $section ) {
        foreach ( $section['settings'] as $key ) {
            if ( $wp_customize->get_setting( $key ) ) {
                $wp_customize->get_setting( $key )->transport = 'postMessage';
            }
        }

        $wp_customize->selective_refresh->add_partial( 'section-'.$section['id'] , array(
            'selector' => $section['selector'],
            'settings' => $section['settings'],
            'render_callback' => false,
        ));
    }

    $wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector'        => '.site-title a',
		'render_callback' => 'one_hive_customize_partial_blogname',
	) );

	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector'        => '.site-description',
		'render_callback' => 'one_hive_customize_partial_blogdescription',
	) );

    $wp_customize->selective_refresh->add_partial( 'custom_logo', array(
        'selector'        => '.site-name',
        'render_callback' => false,
    ) );

}
add_action( 'customize_register', 'one_hive_customizer_partials', 199 );