<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package One_Hive
 */

if ( ! function_exists( 'one_hive_post_thumbnail' ) ) :
/**
 * Displays an optional post thumbnail.
 *
 * Wraps the post thumbnail in an anchor element on index views, or a div
 * element when on single views.
 */
function one_hive_post_thumbnail() {
	if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
		return;
	}

	if ( is_singular() ) :
	?>

	<div class="post-thumbnail">
		<?php the_post_thumbnail(); ?>
	</div><!-- .post-thumbnail -->

	<?php else : ?>

	<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
		<?php
			the_post_thumbnail( 'post-thumbnail', array(
				'alt' => the_title_attribute( array(
					'echo' => false,
				) ),
			) );
		?>
	</a>

	<?php endif; // End is_singular().
}
endif;

if ( ! function_exists( 'one_hive_get_post_date' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time.
	 */
	function one_hive_get_post_date() {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
		);

		$posted_on = sprintf(
			/* translators: %s: post date. */
			esc_html_x( ' %s', 'post date', 'one-hive' ),
			'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark"><span>' . $time_string . '</span></a>'
		);

		echo $posted_on; // WPCS: XSS OK.
	}
endif;

if ( ! function_exists( 'one_hive_get_post_author' ) ) :
	/**
	 * Prints HTML with meta information for the current author.
	 */
	function one_hive_get_post_author() {
		$byline = sprintf(
			/* translators: %s: post author. */
			esc_html_x( ' %s', 'post author', 'one-hive' ),
			'<a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a>'
		);

		echo $byline; // WPCS: XSS OK.

	}
endif;

if( !function_exists( 'one_hive_get_categories' ) ) :
	/**
	 * Function To Get Categories
	 */
	function one_hive_get_categories() {
		if( 'post' == get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$categories_list = get_the_category_list( esc_html__( ' ', 'one-hive' ) );			
			if ( $categories_list ) {
				/* translators: 1: list of categories. */
				printf( esc_html__( ' %1$s', 'one-hive' ), $categories_list ); // WPCS: XSS OK.
			}
		}
	}
endif;

if( !function_exists( 'one_hive_get_tags' ) ) :
	/**
	 * Function To Get Tags
	 */
	function one_hive_get_tags() {
		if( 'post' == get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( '', esc_html_x( ' ', 'list item separator', 'one-hive' ) );
			if( $tags_list ) :
				/* translators: 1: list of tags. */
				printf( esc_html__( ' %1$s', 'one-hive' ), $tags_list ); // WPCS: XSS OK.
			endif;
		}
	}
endif;

if( !function_exists( 'one_hive_get_comments_no' ) ) :
	/**
	 * Function To Get Tags
	 */
	function one_hive_get_comments_no() {
		if( ( comments_open() || get_comments_number() ) ) {
			$comments_number = get_comments_number();
			if( $comments_number == 0 ) {
				echo '<span class="post-comment">' . esc_html__( 'No Comment', 'one-hive' ) . '</span>';
			} else if( $comments_number == 1 ) {
				/* translators: %s: number of comments. */
				printf( '<span class="post-comment">' . esc_html_x( '%s Comment', 'comments-no', 'one-hive' ) . '</span>' , $comments_number );
			} else {
				/* translators: %s: number of comments. */
				printf( '<span class="post-comment">' . esc_html_x( '%s Comment', 'comments-no', 'one-hive' ) . '</span>' , $comments_number );
			}
		}
	}
endif;
