<?php
/**
 * One Hive Theme Customizer
 *
 * @package One_Hive
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function one_hive_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
	$wp_customize->remove_section( 'header_image' );

	// Load Repeater Control
	require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/controls/repeater-control.php';

	// Load Dropdown Multiple Select
	require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/controls/dropdown-multiple-select.php';

	// Load Sanitize Callback
	require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/customizer-functions/sanitize-callback.php';

	// Load Options
	require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/options/option-init.php';

	// Upspell
	require_once trailingslashit( get_template_directory() ) . '/themebeez/upgrade-to-pro/upgrade.php';

	$wp_customize->register_section_type( 'One_Hive_Customize_Section_Upsell' );

	// Register sections.
	$wp_customize->add_section(
		new One_Hive_Customize_Section_Upsell(
			$wp_customize,
			'theme_upsell',
			array(
				'title'    => esc_html__( 'One Hive Pro', 'one-hive' ),
				'pro_text' => esc_html__( 'Upgrade to Pro', 'one-hive' ),
				'pro_url'  => 'https://themebeez.com/themes/one-hive/',
				'priority' => 1,
			)
		)
	);

}
add_action( 'customize_register', 'one_hive_customize_register' );

// Customization Options
require_once trailingslashit( get_template_directory() ) . '/themebeez/customizer/customizer-functions/selective-refresh.php';

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function one_hive_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function one_hive_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function one_hive_customize_preview_js() {
	wp_enqueue_script( 'one-hive-customizer', get_template_directory_uri() . '/themebeez/core/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'one_hive_customize_preview_js' );

if( !function_exists( 'one_hive_dynamic_style' ) ) {
	function one_hive_dynamic_style() {
		?>
		<style>
		<?php
		if ( ! display_header_text() ) :
		?>
			.site-title,
			.site-description {
				position: absolute;
				clip: rect(1px, 1px, 1px, 1px);
			}
		<?php
			endif;
		?>
		</style>
		<?php
	}
	
}
add_action( 'wp_head', 'one_hive_dynamic_style' );
