(function($) {

    'use strict';

    $(document).ready(function() {


        // init retina 

        retinajs();

        // init sticky sidebar

        jQuery('.sticky_portion').theiaStickySidebar({
            additionalMarginTop: 30
        });

        // match height 

        $('.watchheight').matchHeight();

        // main nav 

        $("#oh_mainmenu").aceResponsiveMenu({

            resizeWidth: '1100', // Set the same in Media query       
            animationSpeed: 'fast', //slow, medium, fast
            accoridonExpAll: false //Expands all the accordion menu on click
        });

        $('#oh_mainmenu').removeClass('hide-menu');


        // Add smooth scrolling to all links

        $("a").on('click', function(event) {

            // Make sure this.hash has a value before overriding default behavior
            if (this.hash !== "") {
                // Prevent default anchor click behavior
                event.preventDefault();

                // Store hash
                var hash = this.hash;

                // Using jQuery's animate() method to add smooth page scroll
                // The optional number (800) specifies the number of milliseconds it takes to scroll to the specified area
                $('html, body').animate({
                    scrollTop: $(hash).offset().top
                }, 1000, function() {

                    // Add hash (#) to URL when done scrolling (default click behavior)
                    window.location.hash = hash;
                });
            } // End if
        });


        // init team carousel

        $('.team_carousel').owlCarousel({

            items: 4,
            loop: true,
            margin: 30,
            nav: true,
            dots: false,
            autoplay: true,
            autoplayTimeout: 8000,
            autoplayHoverPause: true,
            navText: ["<i class='fa fa-angle-left'></i>", "<i class='fa fa-angle-right'></i>"],
            responsive: {
                0: {

                    items: 1
                },
                400: {
                    items: 1
                },
                500: {
                    items: 1
                },
                768: {
                    items: 3
                },
                992: {
                    items: 3
                },
                1024: {

                    items: 3
                },
                1200: {
                    items: 4
                }
            },

        });


        // init blog layout one carousel 

        $('.blog_layout_one_carousel').owlCarousel({

            items: 3,
            loop: true,
            margin: 30,
            nav: false,
            dots: true,
            autoplay: true,
            autoplayTimeout: 8000,
            autoplayHoverPause: true,
            responsive: {

                0: {

                    items: 1
                },
                400: {
                    items: 1
                },
                500: {
                    items: 1
                },
                768: {
                    items: 2
                },
                992: {
                    items: 3
                },
                1024: {

                    items: 3
                },
                1200: {
                    items: 3
                }
            },

        });


        // init testinomial carousel

        $('.testinomial_carousel').owlCarousel({

            items: 2,
            loop: true,
            margin: 30,
            nav: false,
            dots: true,
            autoplay: true,
            autoplayTimeout: 8000,
            autoplayHoverPause: true,
            responsive: {

                0: {

                    items: 1
                },
                400: {
                    items: 1
                },
                500: {
                    items: 1
                },
                768: {
                    items: 1
                },
                991: {
                    items: 1
                },
                1024: {

                    items: 2
                },
                1200: {
                    items: 2
                }
            },

        });


        // init testinomial carousel

        $('.blog_layout_two_carousel').owlCarousel({

            items: 3,
            loop: true,
            margin: 25,
            nav: false,
            dots: true,
            autoplay: true,
            autoplayTimeout: 8000,
            autoplayHoverPause: true,
            responsive: {

                0: {

                    items: 1
                },
                400: {
                    items: 1
                },
                500: {
                    items: 1
                },
                768: {
                    items: 2
                },
                992: {
                    items: 3
                },
                1024: {

                    items: 3
                },
                1200: {
                    items: 3
                }
            },

        });


        // init client carousel

        $('.client_carousel').owlCarousel({
            items: 5,
            loop: true,
            margin: 30,
            nav: false,
            dots: false,
            autoplay: true,
            autoplayTimeout: 10000,
            autoplayHoverPause: true,
            responsive: {

                0: {

                    items: 2
                },
                400: {
                    items: 2
                },
                500: {
                    items: 3
                },
                768: {
                    items: 4
                },
                992: {
                    items: 5
                },
                1024: {

                    items: 5
                },
                1200: {
                    items: 5
                }
            },

        });


        // Back to top 

        $('body').append('<div id="toTop" class="btn btn-info"><i class="fa fa-angle-double-up" aria-hidden="true"></i></div>');
        $(window).scroll(function() {
            if ($(this).scrollTop() != 0) {
                $('#toTop').fadeIn();
            } else {
                $('#toTop').fadeOut();
            }
        });
        $('#toTop').click(function() {
            $("html, body").animate({ scrollTop: 0 }, 800);
            return false;
        });

    });
})(jQuery);