<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package One_Hive
 */

	get_header(); 

	$sidebar_position = one_hive_get_option( 'one_hive_global_sidebar_choice' );
?>
	<div class="single_page_main_wrapper">
        <div class="oh_container">
            <div id="primary" class="content-area">
                <main id="main" class="site-main">
                    <div class="row">
                    	<?php
		            		$class = null;
		            		if( $sidebar_position != 'none' && is_active_sidebar( 'sidebar-1' ) ) {
		            			$class = 'col-md-8 col-sm-12 col-xs-12 sticky_portion';
		            		} else {
		            			$class = 'col-md-12 col-sm-12 col-xs-12';
		            		}

		            		if( $sidebar_position == 'left' ) {
		            			get_sidebar();
		            		}
		            	?>
                        <div class="<?php echo esc_attr( $class ); ?>">
                        	<?php
                        		if( have_posts() ) :
		                        	?>
		                            <div class="left_side_content_area">
		                                <div class="post_title">
		                                    <h2>
		                                    	<?php
													/* translators: %s: search query. */
													printf( esc_html__( 'Search Results for: %s', 'one-hive' ), '<span>' . get_search_query() . '</span>' );
												?>
		                                    </h2>
		                                </div><!-- .post_title -->
		                                <?php
		                                	do_action( 'one_hive_breadcrumb' );
		                                ?>
		                                <div class="listings_inside_this_holder">
		                                    <?php
		                                    	/* Start the Loop */
												while ( have_posts() ) : the_post();

													/*
													 * Include the Post-Format-specific template for the content.
													 * If you want to override this in a child theme, then include a file
													 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
													 */
													get_template_part( 'themebeez/templates/template-parts/content', get_post_format() );

												endwhile;
		                                    ?>
		                                </div><!-- .listings_inside_this_holder -->
		                                <?php
		                                	do_action( 'one_hive_pagination' );
		                                ?>
		                            </div><!-- .left_side_content_area -->
		                            <?php
                            	else :

                            		get_template_part( 'themebeez/templates/template-parts/content', 'none' );

                            	endif;
                            ?>
                        </div><!-- .<?php echo esc_attr( $class ); ?> -->
                        <?php
                        	if( $sidebar_position == 'right' ) {
                        		get_sidebar();
                        	}
                        ?>
                    </div><!-- .row -->
                </main><!-- #main.site-main -->
            </div><!-- #primary.content-area -->
        </div><!-- .oh_container -->
    </div><!-- .single_page_main_wrapper -->

<?php
get_footer();
