<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */

	get_header(); 

	$sidebar_position = get_post_meta( absint( get_the_ID() ), 'sidebar', true );

	if( empty( $sidebar_position ) ) {
		$sidebar_position = 'right';
	}
?>
	<div class="single_page_main_wrapper">
        <div class="oh_container">
            <div id="primary" class="content-area">
                <main id="main" class="site-main">
                    <div class="row">
                    	<?php
		            		$class = null;
		            		if( $sidebar_position != 'none' && is_active_sidebar( 'sidebar-1' ) ) {
		            			$class = 'col-md-8 col-sm-12 col-xs-12 sticky_portion';
		            		} else {
		            			$class = 'col-md-12 col-sm-12 col-xs-12';
		            		}

		            		if( $sidebar_position == 'left' ) {
		            			get_sidebar();
		            		}
		            	?>
                        <div class="<?php echo esc_attr( $class ); ?>">
                        	<div class="left_side_content_area">
	                        	<?php
									while ( have_posts() ) : the_post();

										get_template_part( 'themebeez/templates/template-parts/content', 'single' );

										// If comments are open or we have at least one comment, load up the comment template.
										if ( comments_open() || get_comments_number() ) :
											comments_template();
										endif;

									endwhile; // End of the loop.
								?>
							</div><!-- .left_side_content_area -->
                        </div><!-- .<?php echo esc_attr( $class ); ?> -->
                        <?php
                        	if( $sidebar_position == 'right' ) {
		                		get_sidebar();
		                	}
                        ?>
                    </div><!-- .row -->
                </main><!-- #main.site-main -->
            </div><!-- #primary.content-area -->
        </div><!-- .oh_container -->
    </div><!-- .single_page_main_wrapper -->

<?php
get_footer();
