<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package One_Hive
 */

	get_header(); 

	$sidebar_position = one_hive_get_option( 'one_hive_global_sidebar_choice' );
?>
	<div class="single_page_main_wrapper">
        <div class="oh_container">
            <div id="primary" class="content-area">
                <main id="main" class="site-main">
                    <div class="row">
                    	<?php
		            		$class = null;
		            		if( $sidebar_position != 'none' && is_active_sidebar( 'sidebar-1' ) ) {
		            			$class = 'col-md-8 col-sm-12 col-xs-12 sticky_portion';
		            		} else {
		            			$class = 'col-md-12 col-sm-12 col-xs-12';
		            		}

		            		if( $sidebar_position == 'left' ) {
		            			get_sidebar();
		            		}
		            	?>
                        <div class="<?php echo esc_attr( $class ); ?>">
                        	<?php
                        		if( have_posts() ) :
		                        	?>
		                            <div class="left_side_content_area">
		                                <div class="listings_inside_this_holder">
		                                    <?php
		                                    	/* Start the Loop */
												while ( have_posts() ) : the_post();

													/*
													 * Include the Post-Format-specific template for the content.
													 * If you want to override this in a child theme, then include a file
													 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
													 */
													get_template_part( 'themebeez/templates/template-parts/content', get_post_format() );

												endwhile;
		                                    ?>
		                                </div><!-- .listings_inside_this_holder -->
		                                <?php
		                                	do_action( 'one_hive_pagination' );
		                                ?>
		                            </div><!-- .left_side_content_area -->
		                            <?php
                            	else :

                            		get_template_part( 'themebeez/templates/content', 'none' );

                            	endif;
                            ?>
                        </div><!-- .<?php echo esc_attr( $class ); ?> -->
                        <?php
                        	if( $sidebar_position == 'right' ) {
                        		get_sidebar();
                        	}
                        ?>
                    </div><!-- .row -->
                </main><!-- #main.site-main -->
            </div><!-- #primary.content-area -->
        </div><!-- .oh_container -->
    </div><!-- .single_page_main_wrapper -->

<?php
get_footer();
