<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package One_Hive
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php if( get_background_image() || get_background_color() != 'ffffff') : ?>
        <div class="page_wrapper">
    <?php endif; ?>
    
    <?php
    $enable_top_header = one_hive_get_option( 'one_hive_enable_top_header' );        
    ?>
    <header class="oh_general_header oh_header_layout_one">
        <div class="header_inner">
            <?php if( $enable_top_header == 1 ) : ?>
            <div class="header_top">
                <div class="oh_container">
                    <div class="custom_row clearfix">
                        <div class="col">
                            <div class="top_left">
                                <ul class="header_misc_info">
                                    <?php
                                        $phone_no = one_hive_get_option( 'one_hive_phone_no' );
                                        $email = one_hive_get_option( 'one_hive_email' );
                                        $location = one_hive_get_option( 'one_hive_location' );

                                        if( !empty( $phone_no ) ) :
                                            ?>
                                            <li class="top_phone"><span><?php echo esc_html( $phone_no ); ?></span></li>
                                            <?php
                                        endif;

                                        if( !empty( $email ) ) :
                                            ?>
                                            <li class="top_email"><span><?php echo esc_html( $email ); ?></span></li>
                                            <?php
                                        endif;

                                        if( !empty( $location ) ) :
                                            ?>
                                            <li class="top_address"><span><?php echo esc_html( $location ); ?></span></li>
                                            <?php
                                        endif;
                                    ?>
                                </ul><!-- .header_misc_info -->
                            </div><!-- .top_left -->
                        </div><!-- .col -->
                        <div class="col">
                            <div class="top_right">
                                <ul class="social_icons">
                                    <?php
                                        $facebook_link = one_hive_get_option( 'one_hive_facebook_link' );
                                        $twitter_link = one_hive_get_option( 'one_hive_twitter_link' );
                                        $linkedin_link = one_hive_get_option( 'one_hive_linkedin_link' );
                                        $instagram_link = one_hive_get_option( 'one_hive_instagram_link' );
                                        $dribble_link = one_hive_get_option( 'one_hive_dribble_link' );
                                        $vk_link = one_hive_get_option( 'one_hive_vk_link' );

                                        if( !empty( $facebook_link ) ) :
                                            ?>
                                            <li><a href="<?php echo esc_url( $facebook_link ); ?>"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                                            <?php
                                        endif;

                                        if( !empty( $twitter_link ) ) :
                                            ?>
                                            <li><a href="<?php echo esc_url( $twitter_link ); ?>"><i class="fa fa-twitter" aria-hidden="true"></i></a></li>
                                            <?php
                                        endif;

                                        if( !empty( $linkedin_link ) ) :
                                            ?>
                                            <li><a href="<?php echo esc_url( $linkedin_link ); ?>"><i class="fa fa-linkedin" aria-hidden="true"></i></a></li>
                                            <?php
                                        endif;

                                        if( !empty( $instagram_link ) ) :
                                            ?>
                                            <li><a href="<?php echo esc_url( $instagram_link ); ?>"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
                                            <?php
                                        endif;

                                        if( !empty( $dribble_link ) ) :
                                            ?>
                                            <li><a href="<?php echo esc_url( $dribble_link ); ?>"><i class="fa fa-dribbble" aria-hidden="true"></i></a></li>
                                            <?php
                                        endif;

                                        if( !empty( $vk_link ) ) :
                                            ?>
                                            <li><a href="<?php echo esc_url( $vk_link ); ?>"><i class="fa fa-vk" aria-hidden="true"></i></a></li>
                                            <?php
                                        endif;
                                    ?>
                                </ul><!-- .social_icons -->
                                <?php
                                    if( class_exists( 'Woocommerce' ) ) :
                                        ?>
                                        <div class="cart_items">
                                            <p class="cart_count">
                                                <a href="<?php echo esc_url( wc_get_cart_url() ); ?>"><i class="fa fa-shopping-bag" aria-hidden="true"></i></a><sup><span class="count_value"><?php echo absint( WC()->cart->get_cart_contents_count() );?></span></sup>
                                            </p><!-- .cart_count -->
                                        </div><!-- .cart_items -->
                                        <?php
                                    endif;
                                ?>
                            </div><!-- .top_right -->
                        </div><!-- .col -->
                    </div><!-- .row -->
                </div><!-- .oh_container -->
            </div><!-- .header_top -->
            <?php endif; ?>
            <div class="logo_and_nav_holder">
                <div class="oh_container">
                    <div class="row">
                        <div class="col-md-3 col-sm-8 col-xs-8">
                            <div class="site-name">
                            	<?php
                                    if( has_custom_logo() ) :

									   the_custom_logo();

                                    else : 
										?>
										<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1><!-- .site-title -->
										<?php 

                                        $description = get_bloginfo( 'description', 'display' );

                                        if ( $description || is_customize_preview() ) : 
                                            ?>
                                            <p class="site-description"><?php echo $description; /* WPCS: xss ok. */ ?></p><!-- .site-description -->
                                            <?php
                                        endif; 
									endif;
								?>
                            </div><!-- .site-name -->
                        </div><!-- col-* -->
                        <div class="col-md-9 col-sm-4 col-xs-4 cancell_property clearfix">
                            <nav class="primary_navigation">
                                <div class="menu-toggle">
                                    <button type="button" id="menu-btn">
                                        <span class="icon-bar"></span><!-- .icon-bar -->
                                        <span class="icon-bar"></span><!-- .icon-bar -->
                                        <span class="icon-bar"></span><!-- .icon-bar -->
                                    </button><!-- #menu-btn -->
                                </div><!-- .menu-toggle -->
                                <?php
                                	wp_nav_menu( array( 
                            			'theme_location' 	=> 'menu-1',
                            			'menu_class'		=> 'clearfix slide-toggle',
                            			'menu_id'			=> 'oh_mainmenu',
                            			'container'			=> '',
                            			'fallback_cb'       => 'one_hive_navigation_fallback',
                            		 ) );
                                ?>
                            </nav><!-- .primary_navitation.clearfix -->
                        </div><!-- .col-* -->
                    </div><!-- .row -->
                </div><!-- .oh_container -->
            </div><!-- .logo_and_nav_holder -->
        </div><!-- .header_inner -->
    </header><!-- .oh_general_header.oh_header_layout_one -->
