<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package One_Hive
 */

?>
	<?php
		if( is_active_sidebar( 'sidebar-2' ) ) :
			?>
			<footer id="footer">
		        <div class="footer_inner">
		            <div class="oh_container">
		                <div class="row">
		                	<?php
		                		dynamic_sidebar( 'sidebar-2' );
		                	?>
		                </div><!-- .row -->
		            </div><!-- .oh_container -->
		        </div><!-- .footer_inner -->
		    </footer><!-- .footer -->
		    <?php
    	endif;

    	$enable_footer_bottom = one_hive_get_option( 'one_hive_enable_footer_bottom' );

    	if( $enable_footer_bottom == 1 ) :
		    ?>
		    <div class="footer_bottom">
		        <div class="footer_bottom_inner">
		            <div class="oh_container">
		                <div class="footer_bottom_content">
		                	<div class="row">
		                		<?php
		                		
		                			$copyright_text = one_hive_get_option( 'one_hive_footer_copyright_text' );

		                			if( !empty( $copyright_text ) ) :
				                		?>
				                		<div class="col-md-6 col-sm-12 col-xs-12">
				                			<p class="text-left">
				                				<?php
				                					echo esc_html( $copyright_text );
				                				?>
				                			</p><!-- .text-left -->
				                		</div><!-- .col-* -->
				                		<?php
		                			endif;

		                			do_action( 'one_hive_footer_credit' );
		                		?>
		                	</div><!-- .row -->
		                </div><!-- .footer_bottom_content -->
		            </div><!-- .oh_container -->
		        </div><!-- .footer_bottom_inner -->
		    </div><!-- .footer_bottom -->
		    <?php
    	endif;
    ?>
    <?php if( get_background_image() || get_background_color() != 'ffffff' ) : ?>
        </div>
    <?php endif; ?>

	<?php wp_footer(); ?>

</body>
</html>
