<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package One_Hive
 */

get_header(); ?>

	<div class="errror_page_wrapper">
        <div class="oh_container">
            <div id="primary" class="content-area">
                <main id="main" class="site-main">
                    <div class="error_page_contents">
                        <div class="error_header">
                            <?php
                            	echo '<h2>' . esc_html__( '404', 'one-hive') . '<span>' . esc_html__( 'error', 'one-hive' ) . '</span>' . esc_html__( '!', 'one-hive' ) . '</h2>';
                            ?>
                        </div><!-- .error_header -->
                        <div class="error_message">
                            <p>
                            	<?php
                            		echo esc_html__( 'You encounter a 404 error. The page you looking for either has moved or doesn\'t exists in this server', 'one-hive' ) ?>
                            </p>
                        </div><!-- .error_message -->
                        <div class="error_action">
                            <a class="btn-oh-general" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            	<?php 
                            		echo esc_html__( 'Go Homepage', 'one-hive' ); 
                            	?>
                            </a><!-- .btn-oh-general -->
                        </div><!-- .error_action -->
                    </div><!-- .error_page_contents -->
                </main><!-- #main.site-main -->
            </div><!-- #primary.content-area -->
        </div><!-- .oh_container -->
    </div><!-- .error_page_wrapper -->
<?php
get_footer();
