<?php
/**
 * Getting Started Help Notic
 **/
function one_elementor_general_admin_notice(){
?>
<div data-dismissible="disable-done-notice-forever" class="notice notice-info one-elementor-welcome-notice">
    <div class="one-elementor-notice-wrapper">
        <div class="one-elementor-notice-inner">
            <div class="notice-thumbnail-col">
              <img src="<?php echo esc_url(get_theme_file_uri('screenshot.png'));?>" alt="<?php esc_attr_e('One Elmentor', 'one-elementor');?>">
            </div>
            <div class="notice-content-col">
              <h3>
               <?php esc_html_e('Thank you for installing the One Elementor WordPress Theme.', 'one-elementor'); ?>
              </h3>
              <p class="notice-desc">
              <?php esc_html_e('Ready to create a stunning website? Click the Install Starter Website Templates button, and you\'ll be redirected to our demo page to get started.', 'one-elementor'); ?>
              </p>
              <p>
              <a class="one-elementor-btn-get-started button button-primary one-elementor-button-padding" href="#" data-name="" data-slug="">
              <?php esc_html_e( 'Install Starter Website Templates', 'one-elementor' );?></a>
              <a target="_blank" href="<?php echo esc_url(admin_url( '/themes.php?page=one-elementor-getting-started' ));?>" class="button button-highlight btn-doc button-primary" style="color:#fff;"><span style="margin-top:4px;margin-right:5px;" class="dashicons dashicons-video-alt3"></span>
              <?php esc_html_e( ' Getting Started Video', 'one-elementor' );?></a>
              <a target="_blank" href="<?php echo esc_url('https://rswpthemes.com/shofy-premium-multipurpose-woocommerce-theme/');?>" class="button button-highlight upgrade-to-pro button-primary"><?php esc_html_e( 'Explore Premium Version', 'one-elementor' );?></a>
              <a href="?one_elementor_notice_dismissed" style="text-decoration: none; float: right;">
              <?php esc_html_e( 'Dismiss Notice', 'one-elementor' );?></a>
              </p>
            </div>
        </div>
    </div>
</div>
<?php
}

if ( isset( $_GET['one_elementor_notice_dismissed'] ) ){
   update_option('one_elementor_help_notice', 'notice_one_elementor_dismissed');
   set_transient('one_elementor_welcome_notice_dismissed_time', time(), 24 * 60 * 60);
}

add_action('admin_init', function(){
    $one_elementor_help_notice = get_option('one_elementor_help_notice', '');
    if('one_elementor_notice_dismissed' === $one_elementor_help_notice) {
        $dismissed_time = get_transient('one_elementor_welcome_notice_dismissed_time');
        if (false === $dismissed_time && time() > $dismissed_time + ( 24 * 60 * 60 )) {
            delete_option('one_elementor_notice_dismissed');
            delete_transient('one_elementor_welcome_notice_dismissed_time');
            add_action('admin_notices', 'one_elementor_general_admin_notice');
        }
    }
});

$one_elementor_help_notice = get_option('one_elementor_help_notice', '');
if (($one_elementor_help_notice != 'notice_one_elementor_dismissed' || $one_elementor_help_notice === '') ){
   add_action('admin_notices', 'one_elementor_general_admin_notice');
}