<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
* @package One Elementor
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function one_elementor_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) && ! is_active_sidebar( 'sidebar-2' )  ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'one_elementor_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function one_elementor_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'one_elementor_pingback_header' );


// Define the function to check Elementor activation and usage
function one_elementor_active() {
    // Check if Elementor is active
    if (defined('ELEMENTOR_PATH')) {
        // Check if the current page is built with Elementor
        $post_id = get_queried_object_id();
        if (\Elementor\Plugin::$instance->db->is_built_with_elementor($post_id)) {
            return 'container-elementor';
        }
    }
}
// Hook the function to an appropriate action (e.g., init)
add_action('init', 'one_elementor_active');


function one_elementor_theme_by(){
	?>
	<div class="theme-by-wrapper">
		<div class="theme-by-inner">
			<a href="<?php echo esc_url('https://rswpthemes.com/');?>"><?php esc_html_e( 'RS WP THEMES', 'one-elementor' );?></a>
		</div>
	</div>
	<?php
}

add_action('hfe_footer', 'one_elementor_footer_copyright', 999);
function one_elementor_footer_copyright(){
	?>
	<div class="one-elementor-footer__bottom">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="one-elementor-footer__branding text-center">
						<p class="one-elementor-footer__site"><?php esc_html_e('&copy; All Right Reserved ','one-elementor'); ?> <a class="one-elementor-footer__url" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo('title'); ?></a> <?php echo  esc_html(date_i18n( __( 'Y' , 'one-elementor' ) ));?></p>
						<p class="one-elementor-footer__devs">
					    <?php
					    $theme_link = '<a href="' . esc_url('https://rswpthemes.com/one-elementor-wordpress-theme/') . '" target="_blank">' . esc_html__('One Elementor', 'one-elementor') . '</a>';
					    $author_link = '<a href="' . esc_url('https://rswpthemes.com') . '" target="_blank">' . esc_html__('PencilWp', 'one-elementor') . '</a>';

					    printf(
					        esc_html__('Theme %2$s  By  %1$s', 'one-elementor'),
					        $author_link,
					        $theme_link
					    );
					    ?>
					</p>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}