<?php
/**
 * Getting Started Page.
 *
 * @package One Elementor
 */


$one_elementor_theme = wp_get_theme();
$one_elementor_version = $one_elementor_theme->get('Version');
$one_elementor_name = $one_elementor_theme->get('Name');

define('ONE_ELEMENTOR_THEME_VERSION', $one_elementor_version);
define('ONE_ELEMENTOR_THEME_NAME', $one_elementor_name);

if( ! function_exists( 'one_elementor_getting_started_menu' ) ) :
/**
 * Adding Getting Started Page in admin menu
 */
function one_elementor_getting_started_menu(){
	add_theme_page(
		__( '[One Elementor] Getting Started', 'one-elementor' ),
		__( '[One Elementor] Getting Started', 'one-elementor' ),
		'manage_options',
		'one-elementor-getting-started',
		'one_elementor_getting_started_page', $position = 0
	);
}
endif;
add_action( 'admin_menu', 'one_elementor_getting_started_menu' );

if( ! function_exists( 'one_elementor_getting_started_admin_scripts' ) ) :
/**
 * Load Getting Started styles in the admin
 */
function one_elementor_getting_started_admin_scripts( $hook ){
    wp_enqueue_style( 'one-elementor-focus', get_template_directory_uri() . '/includes/getting-started/css/focus.css', false, ONE_ELEMENTOR_THEME_VERSION );
	// Load styles only on our page
	if( 'appearance_page_one-elementor-getting-started' != $hook ) return;

    wp_enqueue_style( 'one-elementor-getting-started', get_template_directory_uri() . '/includes/getting-started/css/getting-started.css', false, ONE_ELEMENTOR_THEME_VERSION );

    wp_enqueue_script( 'plugin-install' );
    wp_enqueue_script( 'updates' );
    wp_enqueue_script( 'one-elementor-getting-started', get_template_directory_uri() . '/includes/getting-started/js/getting-started.js', array( 'jquery' ), ONE_ELEMENTOR_THEME_VERSION, true );
    wp_enqueue_script( 'one-elementor-recommended-plugin-install', get_template_directory_uri() . '/includes/getting-started/js/recommended-plugin-install.js', array( 'jquery' ), ONE_ELEMENTOR_THEME_VERSION, true );
    wp_localize_script( 'one-elementor-recommended-plugin-install', 'one_elementor_start_page', array( 'activating' => __( 'Activating ', 'one-elementor' ) ) );
}
endif;
add_action( 'admin_enqueue_scripts', 'one_elementor_getting_started_admin_scripts' );

if( ! function_exists( 'one_elementor_check_for_icon' ) ) :
/**
 * Check For Icon
**/
function one_elementor_check_for_icon( $arr ) {
	if( ! empty( $arr['svg'] ) ){
		$plugin_icon_url = $arr['svg'];
	}elseif( ! empty( $arr['2x'] ) ){
		$plugin_icon_url = $arr['2x'];
	}elseif( ! empty( $arr['1x'] ) ){
		$plugin_icon_url = $arr['1x'];
	}else{
		$plugin_icon_url = $arr['default'];
	}
	return $plugin_icon_url;
}
endif;

if( ! function_exists( 'one_elementor_getting_started_page' ) ) :
/**
 * Callback function for admin page.
*/
function one_elementor_getting_started_page(){ ?>
	<div class="wrap getting-started">
		<h2 class="notices"></h2>
		<div class="intro-wrap">
			<div class="intro">
				<h3><?php printf( esc_html__( 'Getting started with %1$s v%2$s', 'one-elementor' ), ONE_ELEMENTOR_THEME_NAME, ONE_ELEMENTOR_THEME_VERSION ); ?></h3>
				<h4><?php printf( esc_html__( 'View our video walkthrough and setup guide below.', 'one-elementor' ), ONE_ELEMENTOR_THEME_NAME ); ?></h4>
                <p>
                    <a href="<?php echo esc_url( 'https://rswpthemes.com/shofy-premium-multipurpose-woocommerce-theme/' ); ?>" class="button button-primary" style="text-decoration: none;" target="_blank"><?php esc_html_e( 'Upgrade to Pro', 'one-elementor' ); ?></a>
                </p>
			</div>
		</div>

		<div class="panels">
			<ul class="inline-list">
				<li class="current">
                    <a id="plugins" href="javascript:void(0);">
                       <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22">
                            <defs><style>.a{fill:#354052;}</style></defs>
                            <path class="a" d="M12,23H11V16.43A5.966,5.966,0,0,1,7,18a6.083,6.083,0,0,1-6-6V11H7.57A5.966,5.966,0,0,1,6,7a6.083,6.083,0,0,1,6-6h1V7.57A5.966,5.966,0,0,1,17,6a6.083,6.083,0,0,1,6,6v1H16.43A5.966,5.966,0,0,1,18,17,6.083,6.083,0,0,1,12,23Zm1-9.87v7.74a4,4,0,0,0,0-7.74ZM3.13,13A4.07,4.07,0,0,0,7,16a4.07,4.07,0,0,0,3.87-3Zm10-2h7.74a4,4,0,0,0-7.74,0ZM11,3.13A4.08,4.08,0,0,0,8,7a4.08,4.08,0,0,0,3,3.87Z" transform="translate(-1 -1)"/>
                        </svg>
                        <?php esc_html_e( 'Getting Started', 'one-elementor' ); ?>
                    </a>
                </li>
			</ul>
			<div id="panel" class="panel">
				<?php require get_template_directory() . '/includes/getting-started/tabs/started.php'; ?>
				<?php require get_template_directory() . '/includes/getting-started/tabs/link-panel.php'; ?>
			</div><!-- .panel -->
		</div><!-- .panels -->
	</div><!-- .getting-started -->
	<?php
}
endif;