<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// Overwrite parent theme background defaults and registers support for WordPress features.
add_action( 'after_setup_theme', 'lalita_background_setup' );
function lalita_background_setup() {
	add_theme_support( "custom-background",
		array(
			'default-color' 		 => 'ffffff',
			'default-image'          => '',
			'default-repeat'         => 'repeat',
			'default-position-x'     => 'left',
			'default-position-y'     => 'top',
			'default-size'           => 'auto',
			'default-attachment'     => '',
			'wp-head-callback'       => '_custom_background_cb',
			'admin-head-callback'    => '',
			'admin-preview-callback' => ''
		)
	);
}

// Overwrite theme URL
function lalita_theme_uri_link() {
	return 'https://wpkoi.com/omkara-wpkoi-wordpress-theme/';
}

// Overwrite parent theme's blog header function
add_action( 'lalita_after_header', 'lalita_blog_header_image', 11 );
function lalita_blog_header_image() {

	if ( ( is_front_page() && is_home() ) || ( is_home() ) ) { 
		$blog_header_image 			=  lalita_get_setting( 'blog_header_image' ); 
		$blog_header_title 			=  lalita_get_setting( 'blog_header_title' ); 
		$blog_header_text 			=  lalita_get_setting( 'blog_header_text' ); 
		$blog_header_button_text 	=  lalita_get_setting( 'blog_header_button_text' ); 
		$blog_header_button_url 	=  lalita_get_setting( 'blog_header_button_url' ); 
		if ( $blog_header_image != '' ) { ?>
		<div class="page-header-image grid-parent page-header-blog" style="background-image: url('<?php echo esc_url($blog_header_image); ?>') !important;">
        	<div class="page-header-noiseoverlay"></div>
        	<div class="page-header-blog-inner">
                <div class="page-header-blog-content-h grid-container">
                    <div class="page-header-blog-content">
                    <?php if ( $blog_header_title != '' ) { ?>
                        <div class="page-header-blog-text">
                            <?php if ( $blog_header_title != '' ) { ?>
                            <h2><?php echo wp_kses_post( $blog_header_title ); ?></h2>
                            <div class="clearfix"></div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                    </div>
                </div>
                <div class="page-header-blog-content page-header-blog-content-b">
                	<?php if ( $blog_header_text != '' ) { ?>
                	<div class="page-header-blog-text">
						<?php if ( $blog_header_title != '' ) { ?>
                        <p><?php echo wp_kses_post( $blog_header_text ); ?></p>
                        <div class="clearfix"></div>
                        <?php } ?>
                    </div>
                    <?php } ?>
                    <div class="page-header-blog-button">
                        <?php if ( $blog_header_button_text != '' ) { ?>
                        <a class="read-more button" href="<?php echo esc_url( $blog_header_button_url ); ?>"><?php echo esc_html( $blog_header_button_text ); ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
		</div>
		<?php
		}
	}
}

// Extra cutomizer functions
if ( ! function_exists( 'omkara_customize_register' ) ) {
	add_action( 'customize_register', 'omkara_customize_register' );
	function omkara_customize_register( $wp_customize ) {
				
		// Add Omkara customizer section
		$wp_customize->add_section(
			'omkara_layout_effects',
			array(
				'title' => __( 'Omkara Effects', 'omkara' ),
				'priority' => 1,
				'panel' => 'lalita_layout_panel'
			)
		);
		
		// Header borders
		$wp_customize->add_setting(
			'omkara_settings[header_borders]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'omkara_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'omkara_settings[header_borders]',
			array(
				'type' => 'select',
				'label' => __( 'Header borders', 'omkara' ),
				'choices' => array(
					'enable' => __( 'Enable', 'omkara' ),
					'disable' => __( 'Disable', 'omkara' )
				),
				'settings' => 'omkara_settings[header_borders]',
				'section' => 'omkara_layout_effects',
				'priority' => 1
			)
		);
		
		// Logo decoration
		$wp_customize->add_setting(
			'omkara_settings[logo_decoration]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'omkara_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'omkara_settings[logo_decoration]',
			array(
				'type' => 'select',
				'label' => __( 'Logo decoration', 'omkara' ),
				'choices' => array(
					'enable' => __( 'Enable', 'omkara' ),
					'disable' => __( 'Disable', 'omkara' )
				),
				'settings' => 'omkara_settings[logo_decoration]',
				'section' => 'omkara_layout_effects',
				'priority' => 3
			)
		);
		
		// Top bar scrolling text
		$wp_customize->add_setting(
			'omkara_settings[top_bar_scroll]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'omkara_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'omkara_settings[top_bar_scroll]',
			array(
				'type' => 'select',
				'label' => __( 'Top bar scrolling text', 'omkara' ),
				'choices' => array(
					'enable' => __( 'Enable', 'omkara' ),
					'disable' => __( 'Disable', 'omkara' )
				),
				'settings' => 'omkara_settings[top_bar_scroll]',
				'section' => 'omkara_layout_effects',
				'priority' => 8
			)
		);
		
		// Blog double border
		$wp_customize->add_setting(
			'omkara_settings[blog_double_border]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'omkara_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'omkara_settings[blog_double_border]',
			array(
				'type' => 'select',
				'label' => __( 'Blog double border', 'omkara' ),
				'choices' => array(
					'enable' => __( 'Enable', 'omkara' ),
					'disable' => __( 'Disable', 'omkara' )
				),
				'settings' => 'omkara_settings[blog_double_border]',
				'section' => 'omkara_layout_effects',
				'priority' => 9
			)
		);
		
		// Footer decoration
		$wp_customize->add_setting(
			'omkara_settings[footer_decoration]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'omkara_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'omkara_settings[footer_decoration]',
			array(
				'type' => 'select',
				'label' => __( 'Footer decoration', 'omkara' ),
				'choices' => array(
					'enable' => __( 'Enable', 'omkara' ),
					'disable' => __( 'Disable', 'omkara' )
				),
				'settings' => 'omkara_settings[footer_decoration]',
				'section' => 'omkara_layout_effects',
				'priority' => 2
			)
		);
	}
}

//Sanitize choices.
if ( ! function_exists( 'omkara_sanitize_choices' ) ) {
	function omkara_sanitize_choices( $input, $setting ) {
		// Ensure input is a slug
		$input = sanitize_key( $input );

		// Get list of choices from the control
		// associated with the setting
		$choices = $setting->manager->get_control( $setting->id )->choices;

		// If the input is a valid key, return it;
		// otherwise, return the default
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
	}
}

// The dynamic styles of the parent theme added inline to the parent stylesheet.
// For the customizer functions it is better to enqueue after the child theme stylesheet.
if ( ! function_exists( 'omkara_remove_parent_dynamic_css' ) ) {
	add_action( 'init', 'omkara_remove_parent_dynamic_css' );
	function omkara_remove_parent_dynamic_css() {
		remove_action( 'wp_enqueue_scripts', 'lalita_enqueue_dynamic_css', 50 );
	}
}

// Sticky color CSS
if ( ! function_exists( 'omkara_sticky_css' ) ) {
	function omkara_sticky_css() {
		// Get our settings from parent theme
		$lalita_settings = wp_parse_args(
			get_option( 'lalita_settings', array() ),
			lalita_get_defaults()
		);

		$omkara_stickycolors = 'article.sticky .entry-title a {color: ' . esc_attr( $lalita_settings[ 'link_color_hover' ] ) . '}';
		
		return $omkara_stickycolors;
	}
}

// Enqueue this CSS after the child stylesheet, not after the parent stylesheet.
if ( ! function_exists( 'omkara_enqueue_parent_dynamic_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'omkara_enqueue_parent_dynamic_css', 50 );
	function omkara_enqueue_parent_dynamic_css() {
		$css = lalita_base_css() . lalita_font_css() . lalita_advanced_css() . lalita_spacing_css() . lalita_no_cache_dynamic_css() . omkara_sticky_css();

		// escaped secure before in parent theme
		wp_add_inline_style( 'lalita-child', $css );
	}
}

//Adds custom classes to the array of body classes.
if ( ! function_exists( 'omkara_body_classes' ) ) {
	add_filter( 'body_class', 'omkara_body_classes' );
	function omkara_body_classes( $classes ) {
		// Get Customizer settings
		$omkara_settings = get_option( 'omkara_settings' );
		
		$footer_decoration   = 'enable';
		$logo_decoration  	 = 'enable';
		$top_bar_scroll  	 = 'enable';
		$blog_double_border	 = 'enable';
		$header_borders	 	 = 'enable';
		
		if ( isset( $omkara_settings['footer_decoration'] ) ) {
			$footer_decoration = $omkara_settings['footer_decoration'];
		}
		
		if ( isset( $omkara_settings['logo_decoration'] ) ) {
			$logo_decoration = $omkara_settings['logo_decoration'];
		}
		
		if ( isset( $omkara_settings['top_bar_scroll'] ) ) {
			$top_bar_scroll = $omkara_settings['top_bar_scroll'];
		}
		
		if ( isset( $omkara_settings['blog_double_border'] ) ) {
			$blog_double_border = $omkara_settings['blog_double_border'];
		}
		
		if ( isset( $omkara_settings['header_borders'] ) ) {
			$header_borders = $omkara_settings['header_borders'];
		}
		
		// Footer decoration
		if ( $footer_decoration != 'disable' ) {
			$classes[] = 'omkara-footer-decoration';
		}
		
		// Logo decoration
		if ( $logo_decoration != 'disable' ) {
			$classes[] = 'omkara-logo-decoration';
		}
		
		// Top bar scrolling text
		if ( $top_bar_scroll != 'disable' ) {
			$classes[] = 'omkara-top-bar-scroll';
		}
		
		// Blog image border
		if ( $blog_double_border != 'disable' ) {
			$classes[] = 'omkara-blog-double-border';
		}
		
		// Header borders
		if ( $header_borders != 'disable' ) {
			$classes[] = 'omkara-header-border';
		}
		
		return $classes;
	}
}

if ( ! function_exists( 'omkara_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'omkara_scripts' );
	/**
	 * Enqueue script
	 */
	function omkara_scripts() {
		
		$omkara_settings = get_option( 'omkara_settings' );
		
		$top_bar_scroll = 'enable';
		if ( isset( $omkara_settings['top_bar_scroll'] ) ) {
			$top_bar_scroll = $omkara_settings['top_bar_scroll'];
		}
		
		if ( $top_bar_scroll != 'disable' ) {
			wp_enqueue_script( 'omkara-marquee-js', esc_url( get_stylesheet_directory_uri() ) . "/js/jquery.marquee.min.js", array( 'jquery'), LALITA_VERSION, true );
		}
		
	}
}