
# Ollie — WordPress's Most Popular Block Theme for Full Site Editing

![Image](https://user-images.githubusercontent.com/1415737/217930880-5d019715-f0c2-4f2f-9d24-dd466abf531b.jpg)

**Design better, build faster, publish sooner.** Ollie is a blazing-fast WordPress block theme that makes professional website design accessible to everyone — no coding or expensive page builders required.

## ✨ Why Choose Ollie?

- **🚀 Lightning Fast**: Scores 100% on Core Web Vitals with optimized performance out of the box
- **🎨 50+ Beautiful Patterns**: Pre-designed sections and full-page layouts for instant professional designs
- **🎯 True No-Code Solution**: Seamlessly integrated with WordPress's native site editor — drag, drop, and publish
- **📱 Mobile-First Design**: Every pattern and layout is responsive and optimized for all devices
- **🛠️ Developer Friendly**: Clean, semantic code with modern build tools and translation support
- **🎪 Endless Customization**: 7 style variations, 9 typography presets, and unlimited color combinations

Built by [Mike McAlister](https://mikemcalister.com) and [Patrick Posner](https://patrickposner.com), Ollie empowers both beginners and professionals to create stunning WordPress websites using the latest Full Site Editing features.

## 🚀 Quick Start

| Action | Link |
| --- | --- |
| **View Demo** | [demo.olliewp.com](https://demo.olliewp.com) |
| **Download Theme** | [Latest Release](https://github.com/OllieWP/ollie/releases/latest/download/ollie.zip) |
| **Child Theme** | [Download Child Theme](https://github.com/OllieWP/ollie-child/releases/latest/download/ollie-child.zip) |
| **Documentation** | [olliewp.com/docs](https://olliewp.com/docs) |

### Requirements
- WordPress 6.0 or later
- PHP 7.2 or later

## 📦 Installation

Ollie is available directly from the WordPress theme directory:

1. In your WordPress admin, go to **Appearance → Themes → Add New**
2. Search for "Ollie"
3. Click **Install** and then **Activate**
4. Start designing in **Appearance → Editor**

## 🎨 Features & Capabilities

### Pattern Library
Ollie includes **50+ professionally designed patterns** organized into categories:

- **Full Page Layouts**: Home, About, Features, Pricing, Blog, Contact, Profile
- **Headers & Footers**: Light/Dark variations with different layouts
- **Hero Sections**: Multiple styles with calls-to-action
- **Content Cards**: Testimonials, pricing tables, team members, FAQs
- **Feature Sections**: Service boxes, numbered features, icon grids
- **Blog Components**: Post grids, author boxes, comment sections

### Style Variations
Switch your entire site's look with one click:

- **Default**: Clean, modern design
- **Agency**: Bold, professional styling
- **Creator**: Content-focused layout
- **Startup**: Tech-inspired design
- **Studio**: Minimal, elegant aesthetic

### Color Palettes
Pre-configured color schemes:
- Blue, Green, Neon, Orange, Pink, Red, Teal

### Typography System
**9 typography presets** with carefully selected font pairings using the Mona Sans font family.

## 🛠️ For Developers


### Project Structure
```
ollie/
├── patterns/          # 50+ block patterns
├── parts/            # Template parts (headers, footers)
├── templates/        # Page templates
├── styles/           # Style variations and presets
│   ├── blocks/       # Block-specific styles
│   ├── colors/       # Color palette variations
│   └── typography/   # Typography presets
├── theme.json        # Global styles and settings
└── functions.php     # Theme setup and configuration
```

### Theme Features
- **Translation Ready**: Full internationalization support
- **Pattern Translation**: Automated pattern text extraction
- **Child Theme Support**: Extend without modifying core
- **Modern PHP**: Clean, well-documented code
- **No Build Required**: Works out of the box

### Customization Tips

1. **Create a Child Theme**: Best practice for customizations
2. **Use Global Styles**: Modify colors, typography, and spacing in the Site Editor
3. **Extend Patterns**: Copy and modify existing patterns for your needs
4. **Custom CSS**: Add via Additional CSS in the Customizer or theme.json

## 📚 Working with Full Site Editing

New to Full Site Editing? We've got you covered! Check out our [YouTube channel](https://www.youtube.com/@OllieWP) for helpful tutorials on block themes, site editing, and getting the most out of Ollie.

### Site Editor
Access the visual site builder at **Appearance → Editor** to:
- Edit headers, footers, and templates
- Customize global styles
- Create custom templates
- Build with patterns

### Creating Pages with Patterns
1. Create a new page
2. Insert a full-page pattern from the Ollie collection
3. Apply the "No Title" template for full-width layouts
4. Customize content and publish

### Global Styles
Powered by `theme.json`, customize:
- Color palettes
- Typography scales
- Spacing and layout
- Block defaults

### Exporting Your Design
Share your customizations by exporting from the Site Editor:
**Options menu → Tools → Export**

## 🧪 Development

### Build Tools
Ollie includes modern development tools configured in `package.json`:

```bash
# Watch for pattern changes and auto-escape for translations
npm run dev

# Prepare patterns for translation
npm run translate:patterns
```

### Code Quality
Ollie includes Composer scripts for maintaining code standards:

```bash
# Check PHP syntax
composer run lint

# Scan for WordPress coding standards
composer run wpcs:scan

# Auto-fix coding standard issues
composer run wpcs:fix
```

## 🚀 Ollie Pro

Take your website to the next level with [Ollie Pro](https://olliewp.com/pro/):

- **Setup Wizard**: Get started quickly with guided setup
- **One-Click Starter Sites**: Import complete website designs instantly
- **Premium Pattern Library**: Access exclusive pro patterns
- **Priority Support**: Get help when you need it
- **Regular Updates**: New patterns and features added regularly

[Get Ollie Pro →](https://olliewp.com/pro/)

## 📄 License

Ollie is licensed under the [GPL-3.0 license](https://www.gnu.org/licenses/gpl-3.0.html).

## 🤝 Community & Support

- **Documentation**: [olliewp.com/docs](https://olliewp.com/docs)
- **Support Forum**: [wordpress.org/support/theme/ollie](https://wordpress.org/support/theme/ollie)
- **Bug Reports**: [GitHub Issues](https://github.com/OllieWP/ollie/issues)
- **Feature Requests**: [GitHub Discussions](https://github.com/OllieWP/ollie/discussions)

## 👨‍💻 About

Ollie is created and maintained by [Mike McAlister](https://mikemcalister.com) and [Patrick Posner](https://patrickposner.com).

### Mike McAlister
- 🌐 [Website](https://mikemcalister.com)
- 🐦 [Twitter](https://twitter.com/mikemcalister)

### Patrick Posner
- 🌐 [Website](https://patrickposner.com)
- 🐦 [Twitter](https://x.com/patrickposner_)

### Ollie Resources
- 📺 [YouTube Tutorials](https://www.youtube.com/@OllieWP)
- ✍️ [Blog](https://olliewp.com)

---

**[Download Ollie](https://github.com/OllieWP/ollie/releases/latest/download/ollie.zip)** | **[View Demo](https://demo.olliewp.com)** | **[Get Ollie Pro](https://olliewp.com)**
