<?php
/**
	* Display block with previous and next posts.
	*
	* @package oldschool
	* @since oldschool 1.0
	*
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<div class="post-widgets__prev-next-post">
	<?php
	if ( is_single() && get_previous_post() ) {
		$oldschool_prev_post = get_previous_post();
		?>
		<div class="post-buttons__prev">
			<a class="prev__post-link" href="<?php echo wp_kses_post( get_permalink( $oldschool_prev_post->ID ) ); ?>" title="<?php echo wp_kses_post( apply_filters( 'oldschool_post_title', $oldschool_prev_post->post_title ) ); ?>" rel="nofollow">
				<div class="post-link__content">
					<div class="content-block__icon-prev-arrow">
						<svg class="icon-arrow__prev">
							<use xlink:href="#arrow"></use>
						</svg>
					</div>
					<div class="content-block__post-preview-grid">
						<div class="mob-icon-block__prev"></div>
						<div class="post-preview-grid__img-block">
							<div class="post-image__svg-post-thumbnail">
								<div class="svg-background-icon"></div>
							</div>
							<?php
							if ( has_post_thumbnail() ) {
								echo get_the_post_thumbnail( $oldschool_prev_post->ID, 'medium' );
							}?>
						</div>
						<?php if ( get_the_title() ) : ?>
							<div class="post-preview-grid__title">
								<h3 class="preview-title-block__h3">
									<?php echo wp_kses_post( apply_filters( 'oldschool_post_title', $oldschool_prev_post->post_title ) ); ?>
								</h3>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</a>
		</div>
		<?php } ?>

	<?php
	if ( is_single() && get_next_post() ) {
		$oldschool_next_post = get_next_post();
		?>
		<div class="post-buttons__next">
			<a class="next__post-link" href="<?php echo wp_kses_post( get_permalink( $oldschool_next_post->ID ) ); ?>" title="<?php echo wp_kses_post( apply_filters( 'oldschool_post_title', $oldschool_next_post->post_title ) ); ?>" rel="nofollow">
				<div class="post-link__content">
					<div class="content-block__icon-next-arrow">
						<svg class="icon-arrow__next">
							<use xlink:href="#arrow"></use>
						</svg>
					</div>
					<div class="content-block__post-preview-grid">
						<div class="post-preview-grid__img-block">
							<div class="post-image__svg-post-thumbnail">
								<div class="svg-background-icon"></div>
							</div>
						<?php
							if ( has_post_thumbnail() ) {
								echo get_the_post_thumbnail( $oldschool_next_post->ID, 'medium' );
							} 
						?>
						</div>
						<?php if ( get_the_title() ) : ?>
							<div class="post-preview-grid__title">
								<h3 class="preview-title-block__h3">
									<?php echo wp_kses_post( apply_filters( 'oldschool_post_title', $oldschool_next_post->post_title ) ); ?>
								</h3>
							</div>
						<?php endif; ?>
						<div class="mob-icon-block__next"></div>
					</div>
				</div>
			</a>
		</div>
	<?php } ?>
</div>
