<?php
/**
	* "Old School" post meta navigation block. This template show list of:
	* page views,
	* comments count,
	* publiched date,
	* edit link.
	*
	* In article this block is located after thumbnail to article.
	*
	* @package oldschool
	* @since oldschool 1.0
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>

<ul class="article__meta">
	<?php oldschool_authorship(); ?>
	<li class="post-info__item sleep">
		<div class="meta-item__icon-views">
			<div class="icon-views__svg">
				<div class="eye-icon"></div>
			</div>
		</div>
		<div class="meta-item__meta-counter"></div>
	</li>

	<?php if ( get_comments_number() != 0 ) { ?>
		<li class="post-info__item">
			<div class="meta-item__icon-comment">
				<?php	oldschool_comments_counter_nav(); ?>
			</div>
		</li>
	<?php } ?>

	<li class="post-info__item">
		<div class="meta-item__time-icon">
			<div class="icon-time__svg">
				<div class="clock-icon"></div>
			</div>
			<div class="icon-time__date-block">
				<?php echo wp_kses_post( get_the_date( 'd.m.Y' ) ); ?>
			</div>
		</div>
	</li>
	<?php
	if (
		current_user_can( 'editor' ) ||
		current_user_can( 'administrator' )
	) :
		?>
		<li class="post-info__item meta-item-article-edit">
			<a class="meta-item-article-edit__svg" href="<?php echo wp_kses_post( get_edit_post_link() ); ?>">
				<svg class="svg-icon__edit">
					<use xlink:href="#edit"></use>
				</svg>
			</a>
		</li>
	<?php endif; ?>
</ul>
