<?php
/**
	* OldSchool header mobile navigation template.
	*
	* @package oldschool
	* @since oldschool 1.0
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<div class="mobile-content">
	<div class="header-block__mobile-nav-bar">
		<a class="mobile-skip-link" href="#content">
			<?php esc_html_e( 'Skip to Content', 'oldschool' ); ?>
		</a>
		<button type="button" class="nav-bar-mobile__icon">
			<div class="hamburger-icon-button__icon">
				<div class="header-hamburger__bar-1 hhb"></div>
				<div class="header-hamburger__bar-2 hhb"></div>
				<div class="header-hamburger__bar-3 hhb"></div>
			</div>
		</button>
		<div class="nav-bar-mobile__logo" title="<?php echo esc_url( home_url() ); ?>">
			<div class="header-mobile-block__logo"></div>			
		</div>
	</div>
	<div class="header-block__mobile-nav-content">
		<ul class="mobile-nav-content-show__list">
			<li class="mobile-list__item">
				<div class="mobile-nav-show-item__top-nav">
					<ul class="mob-top-nav__list">
						<li class="top-nav-list__item">
							<div class="top-nav-item__tab-1">
								<button type="button" class="meta-tab mob-top-tab__link">
									<div class="mob-top-link-icon__user-svg add-user-icon">
										<div class="user-icon-plus">
											<div class="hor-stk"></div>
											<div class="vert-stk"></div>
											<div class="vert-stk-back"></div>
										</div>
									</div>
								</button>
							</div>
						</li>
						<li class="top-nav-list__item">
							<div class="top-nav-item__tab-2"></div>
						</li>
						<li class="top-nav-list__item">
							<div class="top-nav-item__tab-3">
								<button type="button" class="mob-top-tab__link search-tab">
									<svg class="mob-top-link-icon__search-svg">
										<use xlink:href="#search"></use>
									</svg>
									<div class="mob-top-link-icon__search-svg-close icon-close"></div>
								</button>
							</div>
						</li>
					</ul>
				</div>
			</li>
			<li class="mobile-list__item">
				<div class="mobile-nav-show-item__meta-nav">
					<div class="mobile-meta-nav__point"></div>
				</div>
				<div class="mobile-nav-show-item__search-block">
					<?php get_search_form(); ?>
				</div>
			</li>
			<li class="mobile-list__item">
				<div class="mobile-nav-show-item__main-nav"></div>
			</li>
		</ul>
		<?php

		// if social links activated, then create block with social icons
		if (
			( get_theme_mod( 'oldschool_social_link_activate', 'disable' ) == 'enable' ) &&
			( ( get_theme_mod( 'oldschool_social_link_location_option', 'both' ) == 'header' ) ||
			( get_theme_mod( 'oldschool_social_link_location_option', 'both' ) == 'both' ) )
		) :
			?>
			<div class="mobile-nav-content-show__social"></div>
				<?php endif; ?>
					<a class="focus-back" href="javascript:void(0);" style="display:none;position:fixed;bottom:-999px;"></a>
					<a class="focus-to-close-btn" href="javascript:void(0);" style="position: fixed;bottom:-999px;"></a>
			</div>
	</div>
