<?php
/**
	*  This template  display header top blocks: block with a logo and description of the site, a block of social networks and search, and a block of entry to the site.
	*
	* @package oldschool
	* @since oldschool 1.0
	*
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<div class="desktop-content">
	<div class="header__top">
		<a class="skip-link" href="#content">
			<span class="arrow-down-stick"></span>
				<?php esc_html_e( 'Skip to Content', 'oldschool' ); ?>
		</a>
		<?php
		get_template_part( 'template-parts/header/header-top/logo', 'title' );
		get_template_part( 'template-parts/header/header-top/search', 'social' );
		get_template_part( 'template-parts/header/header-top/site', 'meta' );
		?>
</div>
<?php
// if header menu exist
if ( has_nav_menu( 'header-menu' ) ) :
	?>
	<div class="header__bottom">
		<!-- if desktop or screen resolution higher then 1023px, header menu will be attached to this block -->

		<!-- fixed menu block -->
		<?php
		if ( get_theme_mod( 'fixed_menu', 'not_fixed' ) == 'fixed' ) :
			?>
			<div class="header-bottom__fixed-nav-block">
				<div class="header-fixed-nav__menu">
					<div class="header-nail__navigation-block <?php oldschool_fixed_menu(); ?>"></div>
				</div>
			</div>
		<?php endif; ?>

		<!-- header menu block -->
		<nav class="header-bottom__navigation" aria-label="<?php esc_attr_e( 'Header Menu', 'oldschool' ); ?>">
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'menu_class' => 'oldschool-header-menu',
				)
			);
			?>
		</nav>
	</div>
<?php endif; ?>
</div>
