<?php
/**
	* This template show footer top block with: logo, title, top footer navigation block and footer social icons block.
	*
	* @package oldschool
	* @since oldschool 1.0
	*
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

/*
	*  if at least one of the blocks (logo, title, top menu and block
	*  with social networking buttons) is activated, then
	*  the footer top block will appear
	*/
if (
	( has_custom_logo() ) ||
	( ! empty( get_bloginfo( 'name' ) ) ) ||
	( has_nav_menu( 'top-footer-menu' ) ) ||
	( ( get_theme_mod( 'oldschool_social_link_activate', 'disable' ) == 'enable' ) &&
	( ( get_theme_mod( 'oldschool_social_link_location_option', 'both' ) == 'footer' ) ||
	( get_theme_mod( 'oldschool_social_link_location_option', 'both' ) == 'both' ) ) )
) :
	?>
<div class="footer-part__top">
	<?php
	/**
		* if at least one of the blocks ( logo and title ) exist, then
		* block with logo and title will appear
		*/

	if (
		( has_custom_logo() ) ||
		( ! empty( get_bloginfo( 'name' ) ) )
	) {
		?>

		<div class="footer-top-block__footer-site-information">
			<div class="footer-site-information__footer-logo-block">
				<?php
				// if logo exist
				if ( has_custom_logo() ) {
					?>
					<div class="footer-top-layer__logo">
						<?php the_custom_logo(); ?>
					</div>
					<?php
				}
				// if title exist
				if ( ! empty( get_bloginfo( 'name' ) ) ) :
					?>
					<div class="footer-top-layer__title">
						<h2 class="footer-title__text">
							<?php bloginfo( 'name' ); ?>
						</h2>
					</div>
					<?php endif; ?>
			</div>

	<!-- displaying years of site creation date and current date -->
		<div class="footer-site-information__copyright">
		<div class="copyright-block__foundation">
			<div class="foundation-block__start-year">
				<?php echo esc_html( mysql2date( 'Y', get_user_option( 'user_registered', 1 ) ) ); ?>
			</div>
		</div>

		<div class="copyright-block__current-year">
			<div class="year-current__year">
				<?php echo esc_html( date( 'Y' ) ); ?>
			</div>
		</div>
	</div>	
</div> 	
<?php } ?>	 
	<?php if ( has_nav_menu( 'top-footer-menu' ) ) : ?>
	<nav class="footer-top-block__navigation" aria-label="<?php esc_attr_e( 'Footer Top Menu', 'oldschool' ); ?>">
		<?php
			wp_nav_menu(
				array(
					'theme_location' => 'top-footer-menu',
					'menu_class' => 'footer-top-navigation__list',
				)
			);
		?>
	</nav>
		<?php
	endif;

	// icons of social networks, if the block of social network links is activated in the site settings
	if (
		( get_theme_mod( 'oldschool_social_link_activate', 'disable' ) == 'enable' ) &&
		( ( get_theme_mod( 'oldschool_social_link_location_option', 'both' ) == 'footer' ) ||
		( get_theme_mod( 'oldschool_social_link_location_option', 'both' ) == 'both' ) )
	) :
		?>
		<div class="footer-widgets__social-icons">
			<ul class="footer-social-icons__list">
				<?php oldschool_social_icons(); ?>
			</ul>
		</div>
<?php endif; ?>

</div>
	<?php
	else :
		return;
	endif;
	?>
