<?php
/**
	* This template display: footer navigation block.
	*
	* @package oldschool
	* @since oldschool 1.0
	*
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
// if footer bottom navigation exist, then this block will exist too
if ( has_nav_menu( 'bottom-footer-menu' ) ) : ?>
	<div class="footer-part__bottom">
		<nav class="footer-bottom-block__navigation" aria-label="<?php esc_attr_e( 'Footer Bottom Menu', 'oldschool' ); ?>">
			<?php
			// footer bottom navigation code
			wp_nav_menu(
				array(
					'theme_location' => 'bottom-footer-menu',
					'menu_class' => 'footer-bottom-navigation__list',
				)
			);
			?>
		</nav>
	</div>
<?php endif; ?>
