<?php
/**
	* This template display slider on main page of the site.
	*
	* @package oldschool
	* @since oldschool 1.0
	*
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
/**
	*
	* if the user has chosen the option to display the slider
	* in the theme settings, then a block with a slider will be displayed
	*/
if ( get_theme_mod( 'featured_display', 'disable' ) == 'enable' ) {
	?>
<div class="content-block-part__slider">
	<div class="automatron-slider__slideshow">
		<?php
		$oldschool_post_number = 0;
		$oldschool_get_cat_id = oldschool_slider_categories();
		$oldschool_categories = '';

		// get categories lists
		if ( 0 != $oldschool_get_cat_id ) {
			$oldschool_args = array(
				'category__in' => $oldschool_get_cat_id,
				'showposts' => 3,
				'orderby' => 'rand',
				'ignore_sticky_posts' => 1,
			);
		} else {
			$oldschool_site_categories = get_categories();
			$oldschool_get_one_category = $cat;

			foreach ( $oldschool_site_categories as $oldschool_get_one_category ) {
				$oldschool_input_array[] = $oldschool_get_one_category->term_id;
			}
			$oldschool_site_category_id = rand( 0, count( $oldschool_site_categories ) - 1 );
			$oldschool_args = array(
				'category__in' => $oldschool_input_array[ $oldschool_site_category_id ],
				'showposts' => 3,
				'orderby' => 'rand',
				'ignore_sticky_posts' => 1,
			);
		}

		$oldschool_query = new WP_Query( $oldschool_args );
		$oldschool_post_count = $oldschool_query->post_count;
		$oldschool_display_value = '';

		// if categories have posts
		if ( $oldschool_query->have_posts() ) :
			while ( $oldschool_query->have_posts() ) :
				$oldschool_post_number++;
				$oldschool_query->the_post();

				if ( 1 == $oldschool_post_number ) :
					$oldschool_display_value = 'slide--flex';
				else :
					$oldschool_display_value = 'slide--none';
				endif;
				?>
	<div class="slider-grid__content-block slideshow--fade <?php esc_attr( $oldschool_display_value ); ?>">
		<div class="slider-item__dark-background"></div>
		<div class="slider-item__slide-numbers">
				<?php
				echo esc_attr( $oldschool_post_number );
				echo ' / ';
				echo esc_attr( $oldschool_post_count );
				?>
		</div>

		<div class="slider-item__post-img-section">
			<div class="news-block__post-image">
				<?php
					if ( has_post_thumbnail() ) {
						set_post_thumbnail_size( 770, 770, array( 'center', 'center' ) );
						the_post_thumbnail();
					} else {
						/* if the post does not have thumbnail, then the slider will display a special block with the background icon */
						?>
						<div class="post-image__svg-post-thumbnail">
							<div class="svg-background-icon"></div>
						</div>
					<?php } ?>
			</div>
		</div>

		<!-- slide title with link and headline-->
		<div class="slider-item__slide-title">
			<a class="slider-title-block__link" onclick="return !window.open( this.href )" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
				<h3 class="slider-link__title-post-headline" title="<?php the_title(); ?>">
					<?php the_title(); ?>
				</h3>
			</a>
		</div>
	</div>

				<?php
	endwhile;
	endif;
		wp_reset_query();
		?>

	<!-- slider navigation buttons with previous and next slide buttons -->
	<div class="slider-grid__navigation-block">
		<div class="slider-navigation-block__buttons">
			<!-- previous slide button -->
			<a class="slider-buttons__prev" href="javascript:void(0);" onclick="slider.prevSlide()">
				<div class="slider-btn-icons__buttons-block">
					<svg class="slider-btn-icons__svg-icon">
						<use xlink:href="#arrow"></use>
					</svg>
				</div>
			</a>

			<!-- next slide button -->
			<a class="slider-buttons__next" href="javascript:void(0);" onclick="slider.nextSlide()">
				<div class="slider-btn-icons__buttons-block">
					<svg class="slider-btn-icons__svg-icon">
						<use xlink:href="#arrow"></use>
					</svg>
				</div>
			</a>

		</div>
	</div>
	</div>


<!-- slider dots -->
<div class="automatron-slider__dots-block">
	<?php for ( $oldschool_count_number = 0; $oldschool_count_number < $oldschool_post_count; $oldschool_count_number++ ) : ?>
		<a class="slider-dots-block__dot 
			<?php if ( $oldschool_count_number == 0 ) : ?> slide--active <?php endif; ?>"
				onclick="slider.currentSlide( 
					<?php echo esc_attr( $oldschool_count_number ); ?> 
				);" 
				href="javascript:void(0);" >
		</a>
	<?php endfor; ?>
</div>
</div>
<?php } ?>
