<?php
/**
	* "Old School" sidebar template. Template used to show content of right sidebars, if sidebars exist.
	*
	* @package oldschool
	* @since oldschool 1.0
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
	/*
	* Sidebar content block
	*/
// sidebar block, if user choose option in site preferences 1 sidebar or 2 sidebars
if (
	( get_theme_mod( 'sidebars', 'no_sidebar' ) == 'one_sidebar' ) ||
	( get_theme_mod( 'sidebars', 'no_sidebar' ) == 'two_sidebars' ) ) :
	?>
	<aside class="content-block__sidebar">
		<div class="sidebar-widget-area">
			<?php
			// if user choose 1 or 2 sidebars option, then in main page, search result page and category page will display sidebar-1
			if (
				( get_theme_mod( 'sidebars', 'no_sidebar' ) == 'one_sidebar' ) ||
				( get_theme_mod( 'sidebars', 'no_sidebar' ) == 'two_sidebars' ) &&
				( is_archive() || is_home() || is_search() ) &&
				( is_active_sidebar( 'oldschool-sidebar-1' ) )
			) :
				dynamic_sidebar( 'oldschool-sidebar-1' );
				// if user choose 2 sidebars option, then in article or post page or default page will display sidebar-2
			elseif (
				( get_theme_mod( 'sidebars', 'no_sidebar' ) == 'two_sidebars' ) &&
				( is_singular() ) &&
				( is_active_sidebar( 'oldschool-sidebar-2' ) )
			) :
				dynamic_sidebar( 'oldschool-sidebar-2' );
			 endif;
			?>
		</div>
	</aside>
<?php endif; ?>
