<?php
/**
 * This themplate display the searchform.
 *
 * @package oldschool
 * @since oldschool 1.0
 *
 **/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<form role="search" class="search-form" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<input class="search-form__field" name="s" type="text" value="<?php echo get_search_query(); ?>" placeholder="<?php esc_attr_e( 'Search here...', 'oldschool' ); ?>">
		<button class="search-form__button" type="submit">
			<!-- svg icon -->
			<svg class="search-form__icon">
				<use xlink:href="#search"></use>
			</svg>
		</button>
</form>
