<?php
/**
	* Adding Customizer functions.
	*
	* @package oldschool
	* @since oldschool 1.0
	*
	*/
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
/*---------------------------------------------
	TABLE OF CONTENTS:
---------------------------------------------*/
	/**
	*  0.0.  OldSchool sanitize functions
	*  1.0.  Header Social Icons
	*  2.0.  Theme Customizer
	*  3.0.  Comment Template Modification
	*  4.0.  Automatron Slider
	*  5.0.  Show Author In Post
	*  6.0.  Wrapper Width
	*
	*/
add_action( 'customize_register', 'oldschool_customizer_settings' );
function oldschool_customizer_settings( $wp_customize ) {

	/*---------------------------------------------
	0.0.  OldSchool sanitize functions
	---------------------------------------------*/
	/*
	*  1.0. Radio box sanitization function
	*/
	function oldschool_sanitize_radio( $input, $setting ) {
		//input must be a slug: lowercase alphanumeric characters, dashes and underscores are allowed only
		$input = sanitize_key( $input );
		//get the list of possible radio box options
		$choices = $setting->manager->get_control( $setting->id )->choices;

		//return input if valid or return default option
			return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
	}

	/*
	*  2.0. Checkbox sanitization function
	*/

	function oldschool_sanitize_checkbox( $input ) {
		//returns true if checkbox is checked
		return ( isset( $input ) ? true : false );
	}

	/*
	*  3.0. Select sanitization function
	*/

	function oldschool_sanitize_select( $input, $setting ) {
		//input must be a slug: lowercase alphanumeric characters, dashes and underscores are allowed only
		$input = sanitize_key( $input );

		//get the list of possible select options
		$choices = $setting->manager->get_control( $setting->id )->choices;

		//return input if valid or return default option
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
	}

	/*---------------------------------------------
	1.0.  Header Social Icons
	---------------------------------------------*/
	function oldschool_create_social_icons( $wp_customize ) {
		// Start of the Social Link Options
		$wp_customize->add_section(
			'social_section',
			array(
				'title'       => esc_html__( 'Social Networks', 'oldschool' ),
				'description' => esc_html__( 'Block of social networks, enter the link in the field and click "Save"', 'oldschool' ),
				'priority'    => 35,
			)
		);

		$wp_customize->add_setting(
			'oldschool_social_link_activate',
			array(
				'default'           => 'disable',
				'capability'        => 'edit_theme_options',
				'sanitize_callback' => 'oldschool_sanitize_radio',
			)
		);

		$wp_customize->add_control(
			'oldschool_social_link_activate',
			array(
				'label'    => esc_html__( 'Check to activate social links area', 'oldschool' ),
				'section'  => 'social_section',
				'settings' => 'oldschool_social_link_activate',
				'type'     => 'radio',
				'choices'  => array(
					'disable' => esc_html__( 'Disable', 'oldschool' ),
					'enable'  => esc_html__( 'Enable', 'oldschool' ),
				),
			)
		);

		// Social link location option.
		$wp_customize->add_setting(
			'oldschool_social_link_location_option',
			array(
				'default'           => 'both',
				'capability'        => 'edit_theme_options',
				'sanitize_callback' => 'oldschool_sanitize_radio',
			)
		);

		$wp_customize->add_control(
			'oldschool_social_link_location_option',
			array(
				'label'    => esc_html__( 'Social links to display on:', 'oldschool' ),
				'section'  => 'social_section',
				'settings' => 'oldschool_social_link_location_option',				
				'type'     => 'radio',
				'choices'  => array(
					'header' => esc_html__( 'Header only', 'oldschool' ),
					'footer' => esc_html__( 'Footer only', 'oldschool' ),
					'both'   => esc_html__( 'Both header and footer', 'oldschool' ),
				),
			)
		);

		// Selective refresh for displaying social icons/links
		if ( isset( $wp_customize->selective_refresh ) ) {
			$wp_customize->selective_refresh->add_partial(
				'oldschool_social_link_activate',
				array(
					'selector'        => '.social-links',
					'render_callback' => '',
				)
			);
		}

		$oldschool_social_links = array(
			'oldschool_social_facebook' => array(
				'id'      => 'oldschool_social_facebook',
				'title'   => esc_html__( 'Facebook', 'oldschool' ),
				'default' => '',
			),
			'oldschool_social_vkontakte' => array(
				'id'      => 'oldschool_social_vkontakte',
				'title'   => esc_html__( 'Vkontakte', 'oldschool' ),
				'default' => '',
			),
			'oldschool_social_odnoklassniki' => array(
				'id'      => 'oldschool_social_odnoclassniki',
				'title'   => esc_html__( 'Odnoklassniki', 'oldschool' ),
				'default' => '',
			),
			'oldschool_social_twitter' => array(
				'id'      => 'oldschool_social_twitter',
				'title'   => esc_html__( 'Twitter', 'oldschool' ),
				'default' => '',
			),
			'oldschool_social_youtube' => array(
				'id'      => 'oldschool_social_youtube',
				'title'   => esc_html__( 'YouTube', 'oldschool' ),
				'default' => '',
			),
			'oldschool_social_telegram' => array(
				'id'      => 'oldschool_social_telegram',
				'title'   => esc_html__( 'Telegram', 'oldschool' ),
				'default' => '',
			),
			'oldschool_social_instagram' => array(
				'id'      => 'oldschool_social_instagram',
				'title'   => esc_html__( 'Instagram', 'oldschool' ),
				'default' => '',
			),
		);
		$i = 20;
		foreach ( $oldschool_social_links as $oldschool_social_link ) {
			$wp_customize->add_setting(
				$oldschool_social_link['id'],
				array(
					'default'           => $oldschool_social_link['default'],
					'capability'        => 'edit_theme_options',
					'sanitize_callback' => 'esc_url_raw',
				)
			);
			$wp_customize->add_control(
				$oldschool_social_link['id'],
				array(
					'label'    => $oldschool_social_link['title'],
					'section'  => 'social_section',
					'settings' => $oldschool_social_link['id'],
					'priority' => $i,
				)
			);
			$i++;
		}
	} // End of the "oldschool_create_social_icons"

	/*---------------------------------------------
	2.0.  Theme Customizer
	---------------------------------------------*/
	// This option changes post styles in main page, archive page and search page.
	function oldschool_theme_customizer_options( $wp_customize ) {
		$wp_customize->add_panel(
			'theme_customizer_panel',
			array(
				'priority'   => 38,
				'title'      => esc_html__( 'Theme Customizer', 'oldschool' ),
				'capability' => 'edit_theme_options',
			)
		);

		// Loop Types
		$wp_customize->add_section(
			'oldschool_loop',
			array(
				'priority'    => 1,
				'title'       => esc_html__( 'Post Styles', 'oldschool' ),
				'description' => esc_html__( 'Styles display posts in the loop', 'oldschool' ),
				'panel'       => 'theme_customizer_panel',
			)
		);
		$wp_customize->add_setting(
			'loop',
			array(
				'default'            => 'columns',
				'transport'          => 'refresh',
				'sanitize_callback'  => 'oldschool_sanitize_radio',
			)
		);
		$wp_customize->add_control(
			'loop',
			array(
				'section'    => 'oldschool_loop',
				'label'      => esc_html__( 'Post Styles', 'oldschool' ),
				'type'       => 'radio',
				'capability' => 'edit_theme_options',
				'choices'    => array(
					'columns' => esc_html__( 'Two Columns', 'oldschool' ),
					'list'    => esc_html__( 'List Of Posts', 'oldschool' ),
				),
			)
		);
		//Quantity Of Sidebars
		$wp_customize->add_section(
			'oldschool_sidebars',
			array(
				'priority' => 1,
				'title'    => esc_html__( 'Sidebar', 'oldschool' ),
				'panel'    => 'theme_customizer_panel',
			)
		);
		$wp_customize->add_setting(
			'sidebars',
			array(
				'default'           => 'no_sidebar',
				'transport'         => 'refresh',
				'sanitize_callback' => 'oldschool_sanitize_radio',
			)
		);
		$wp_customize->add_control(
			'sidebars',
			array(
				'section'    => 'oldschool_sidebars',
				'label'      => esc_html__( 'Quantity Of Sidebars', 'oldschool' ),
				'type'       => 'radio',
				'capability' => 'edit_theme_options',
				'choices'    => array(
					'no_sidebar'   => esc_html__( 'No Sidebar', 'oldschool' ),
					'one_sidebar'  => esc_html__( 'One Sidebar', 'oldschool' ),
					'two_sidebars' => esc_html__( 'Two Sidebars', 'oldschool' ),
				),
			)
		);
		//Red Fixed Menu
		$wp_customize->add_section(
			'oldschool_menu_options',
			array(
				'priority' => 1,
				'title'    => esc_html__( 'Header Menu', 'oldschool' ),
				'panel'    => 'theme_customizer_panel',
			)
		);
		$wp_customize->add_setting(
			'fixed_menu',
			array(
				'default'           => 'not_fixed',
				'transport'         => 'refresh',
				'sanitize_callback' => 'oldschool_sanitize_radio',
			)
		);
		$wp_customize->add_control(
			'fixed_menu',
			array(
				'section'    => 'oldschool_menu_options',
				'label'      => esc_html__( 'Fixed Or Not Fixed Red Menu', 'oldschool' ),
				'type'       => 'radio',
				'capability' => 'edit_theme_options',
				'choices'    => array(
					'not_fixed' => esc_html__( 'Not Fixed', 'oldschool' ),
							'fixed' => esc_html__( 'Fixed', 'oldschool' ),
				),
			)
		);
	}
	/*---------------------------------------------
	3.0.  Comment Template Modification
	---------------------------------------------*/

	// This option will modify comments template, by removing: author name link, avatar and disable WordPress comment edit link

	function oldschool_comments_options( $wp_customize ) {
		$wp_customize->add_section(
			'comments',
			array(
				'title'       => esc_html__( 'Comments Template Options', 'oldschool' ),
				'description' => esc_html__( 'Change The Avatar To Defaul OldSchool Avatar Icon', 'oldschool' ),
				'priority'    => 39,
			)
		);
		$wp_customize->add_setting(
			'avatar_svg_icon_enabled',
			array(
				'default'            => 'disable',
				'transport'          => 'refresh',
				'sanitize_callback'  => 'oldschool_sanitize_radio',
			)
		);
		$wp_customize->add_setting(
			'avatar_name_link_disabled',
			array(
				'default'            => 'disable',
				'transport'          => 'refresh',
				'sanitize_callback'  => 'oldschool_sanitize_radio',
			)
		);
		$wp_customize->add_setting(
			'edit_link_disabled',
			array(
				'default'            => 'enable',
				'transport'          => 'refresh',
				'sanitize_callback'  => 'oldschool_sanitize_radio',
			)
		);
		$wp_customize->add_control(
			'avatar_svg_icon_enabled',
			array(
				'label'      => esc_html__( 'Change WordPress Comment Avatar To Avatar Icon', 'oldschool' ),
				'section'    => 'comments',
				'type'       => 'radio',
				'capability' => 'edit_theme_options',
				'choices'    => array(
					'disable' => esc_html__( 'Disable', 'oldschool' ),
					'enable'  => esc_html__( 'Enable', 'oldschool' ),
				),
			)
		);
		$wp_customize->add_control(
			'avatar_name_link_disabled',
			array(
				'label'      => esc_html__( 'Disable WordPress Comment Avatar Name Link, To Avatar Name Text', 'oldschool' ),
				'section'    => 'comments',
				'type'       => 'radio',
				'capability' => 'edit_theme_options',
				'choices'    => array(
					'disable' => esc_html__( 'Disable', 'oldschool' ),
					'enable'  => esc_html__( 'Enable', 'oldschool' ),
				),
			)
		);
		$wp_customize->add_control(
			'edit_link_disabled',
			array(
				'label'      => esc_html__( 'Disable WordPress Comment Edit Link', 'oldschool' ),
				'section'    => 'comments',
				'type'       => 'radio',
				'capability' => 'edit_theme_options',
				'choices'    => array(
					'disable' => esc_html__( 'Disable', 'oldschool' ),
					'enable'  => esc_html__( 'Enable', 'oldschool' ),
				),
			)
		);
	}

	/*---------------------------------------------
	4.0.  Automatron Slider
	---------------------------------------------*/
	/**
	* Adding Automatron Slider to: main page, archive page and search page.
	*/
	function oldschool_featured_posts( $wp_customize ) {
		$oldschool_featured_transport = 'refresh';
		$wp_customize->add_section(
			'oldschool_featured_options',
			array(
				'title'       => esc_html__( 'Automatron Slider', 'oldschool' ),
				'description' => esc_html__( 'Enable / Disable Oldschool Automatron Slider', 'oldschool' ),
				'priority'    => 39,
			)
		);
		$wp_customize->add_setting(
			'featured_display',
			array(
				'default'           => 'disable',
				'transport'         => $oldschool_featured_transport,
				'sanitize_callback' => 'oldschool_sanitize_radio',
			)
		);
		$wp_customize->add_control(
			'featured_display',
			array(
				'section' => 'oldschool_featured_options',
				'label'   => esc_html__( 'Show Slider', 'oldschool' ),
				'type'       => 'radio',
				'capability' => 'edit_theme_options',
				'choices'    => array(
					'disable' => esc_html__( 'Disable', 'oldschool' ),
					'enable'  => esc_html__( 'Enable', 'oldschool' ),
				),
			)
		);
		$categories = get_categories(
			array( 'hide_empty' => false )
		);
		$wp_customize->add_setting(
			'oldschool_featured_category',
			array(
				'default'           => 0,
				'type'              => 'theme_mod',
				'transport'         => $oldschool_featured_transport,
				'sanitize_callback' => 'oldschool_sanitize_select',
			)
		);
		if ( ! empty( $categories ) ) {
			$cat1 = array();
				$i = 0;
				$cat[0] = 'Show all categories';

			foreach ( $categories as $category ) {
				$cat1[] = $category->name . '(' . $category->count . ')';
			}

			foreach ( $categories as $category ) {
				$cat[ $category->term_id ] = $cat1[ $i ];
				$i++;
			}
		}

		$wp_customize->add_control(
			'oldschool_featured_category',
			array(
				'section'   => 'oldschool_featured_options',
				'type'      => 'select',
				'choices'   => $cat,
				'transport' => $oldschool_featured_transport,
			)
		);
	}
	/*---------------------------------------------
		5.0.  Show Author In Post
	---------------------------------------------*/
	/*
	* This option will modify comments template, by removing: author name link, avatar and disable WordPress comment edit link
	*/
	function oldschool_article_authorship( $wp_customize ) {

		$wp_customize->add_section(
			'authorship',
			array(
				'title'       => esc_html__( 'Authorship', 'oldschool' ),
				'description' => esc_html__( 'Enable Or Disable Author Name In Post', 'oldschool' ),
				'priority'    => 39,
			)
		);
		$wp_customize->add_setting(
			'author_name',
			array(
				'default'            => 'enable',
				'sanitize_callback'  => 'oldschool_sanitize_radio',
			)
		);
		$wp_customize->add_control(
			'author_name',
			array(
				'section'    => 'authorship',
				'label'      => esc_html__( 'Disable Author Name', 'oldschool' ),
				'type'       => 'radio',
				'capability' => 'edit_theme_options',
				'choices'    => array(
					'enable'  => esc_html__( 'Enable', 'oldschool' ),
					'disable' => esc_html__( 'Disable', 'oldschool' ),
				),
			)
		);
	}

} // end of "oldschool_customizer_settings" func

add_action( 'customize_register', 'oldschool_create_social_icons' );
add_action( 'customize_register', 'oldschool_theme_customizer_options' );
add_action( 'customize_register', 'oldschool_comments_options' );
add_action( 'customize_register', 'oldschool_featured_posts' );
add_action( 'customize_register', 'oldschool_article_authorship' );

